<?php

use App\Http\Controllers\admin\DeliveryHubController;
use App\Http\Controllers\api\CartController;
use App\Http\Controllers\api\NotificationController;
use App\Http\Controllers\api\OrderControler;
use App\Http\Controllers\api\ProductControler;
use App\Http\Controllers\api\WalletControler;
use App\Http\Controllers\auth\AuthController;
use App\Http\Controllers\User\UserController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });



Route::prefix('user')->group(function () {
    Route::get('payment-methods/add-money',[WalletControler::class,'getAddMoneyPaymentMethods'])->name('add-money-payment-methods');
    Route::get('/', [UserController::class, 'index'])->name('home');
    // Route::get('/f', [UserController::class, 'jndex']);
    Route::controller(AuthController::class)->group(function(){
        Route::post('/signin', 'signIn')->name('signIn');
        Route::post('/signup', 'signUp')->name('signUp');
        Route::get('test',[AuthController::class,'test'])->name('auth.login.test');
        Route::get('/generate-otp', 'generateOtp')->name('generate-otp');
        Route::get('/verify-phone', 'showVerificationPage')->name('show-verification');
        Route::post('/verify-phone', 'verifyPhone')->name('verify-phone');
    });




    Route::get('/home-page-data', [ProductControler::class, 'getHomePageData'])->name('home-page-data');
    Route::get('/products', [ProductControler::class, 'getProductInGroup']);
    Route::post('/cart-items', [CartController::class, 'getCartItems']);
    Route::get('/products/info', [ProductControler::class, 'getProductInfo']);
    Route::get('/products/basic-info', [ProductControler::class, 'productBasicInfo']);
    Route::get('product/details/{id}', [ProductControler::class, 'getProductDetails']);
    Route::get('/category-products', [ProductControler::class, 'getCategoryProducts']);
    Route::get('/categories', [ProductControler::class, 'getCategories']);
    Route::get('/shops', [ProductControler::class, 'getShops']);
    Route::post('/coupon/apply', [OrderControler::class, 'applyCoupon']);
    Route::get('/charges', [OrderControler::class, 'getCharges'])->name('charges');



    Route::get('/return/list', [OrderControler::class, 'returnRequests']);



    Route::get('products/offer/{offerId}', [ProductControler::class, 'getOfferProduts']);
    // Authenticated Routes goes here

    Route::middleware('auth:sanctum')->group(function () {
        Route::get('/f', [UserController::class, 'jndex'])->name('user-data');

        Route::prefix('order')->as('order.')->controller(OrderControler::class)->group(function(){
            Route::get('list', 'getOrderListForUser')->name('list');
            Route::get('details/{id}', 'getOrderDetails')->name('details');
            Route::get('cancel/{id}', 'cancelOrder')->name('cancel');
            Route::post('place', 'placeOrder')->name('place');
        });

        Route::as('wallet.')->controller(WalletControler::class)->group(function(){
            Route::get('/cash-wallet-history', 'cashWalletHistory');
            Route::get('/commission-wallet-history', 'commissionWalletHistory');
            Route::get('/withdraw-request', 'withdrawRequests');
            Route::post('/add-money', 'addMoneyFromBkashToWallet');
            Route::post('/withdraw-money', 'withdrawMoney');
            Route::get('/balance', 'getWalletBalance');
        });

        Route::controller(AuthController::class)->group(function(){
            Route::put('/update-profile', 'updateProfile')->name('profile.update');
            Route::get('/profile', 'userDetails')->name('profile.details');
            Route::post('/logout', 'logout')->name('logout');
            Route::get('/referrals', 'getReferrals')->name('referrals');
            Route::get('teams', 'getTeam')->name('teams');
        });

        Route::prefix('notification')->as('notification.')->controller(NotificationController::class)->group(function(){
            Route::get('list','index')->name('list');
            Route::get('count','checkNotification')->name('notification-check');
            Route::get('mark-as-read','markAsRead')->name('mark-as-read');
        });

        Route::post('/return/request', [OrderControler::class, 'returnItem']);
    });
});


Route::controller(ProductControler::class)->group(function(){
    Route::get('/subcategories/{category_id}', 'getSubcategoryByCategory')->name('subcategories');
    Route::get('/brands/{company_id}', 'getBrands')->name('getBrands');
    Route::get('/basic-products','getProductBasicInfo')->name('basic-info');
});


Route::get('/districts/{division_id}', [DeliveryHubController::class, 'districts'])->name('districts');
Route::get('payment-methods/add-money',[WalletControler::class,'getAddMoneyPaymentMethods'])->name('add-money-payment-methods');
Route::get('limit/withdrawal',[WalletControler::class,'getWithdarwalLimit'])->name('wirhdrawal limit');
