<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Shop extends Model
{
    use HasFactory;
    protected $table = 'tbl_shop';
    protected $appends = ["shop_logo_url"];

    protected $guarded = [];

    public function scopeFilter($query){
        $type=request('_type');
        if($type=='seller'){
            $query->whereHas('user',function($query){
                $query->where('role',SELLER);
            });
        }
        if($type=='deller'){
            $query->whereHas('user',function($query){
                $query->where('role',DELLER);
            });
        }
    }

    public function getShopLogoUrlAttribute()
    {
        if ($this->shop_logo) {
            return url("images/" . $this->shop_logo);
        } else {
            return "https://upload.wikimedia.org/wikipedia/commons/thumb/a/ac/No_image_available.svg/1024px-No_image_available.svg.png";
        }
    }

    public function user()
    {
        return $this->belongsTo(User::class, "user_id", "id");
    }

    public function products(){
        return $this->hasMany(Product::class,'shop_id');
    }

    public function getNameAttribute(){
        if(getLang()=='en'){
            return $this->shop_name_en;
        }else{
            return $this->shop_name_bn;
        }
    }
}
