<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class ReturnedItem extends Model
{
    use HasFactory;
    protected $table = 'tbl_returned_items';
    public $fillable = ['user_id','order_item_id','image','reason','note','admin_note','status','created_at','updated_at'];



    public function getStatusTextAttribute(){
        if($this->status == RETURN_REQUEST_PENDING){
            return 'Request Pending';
        }else if($this->status == RETURN_REQUEST_ACCEPTED){
            return 'Request Accepted';
        }else if($this->status == RETURN_REQUEST_REJECTED){
            return 'Request Rejected';
        }else if($this->status == REFUNDED_BY_SELLER){
            return 'Item Retuned';
        }
    }

    public function orderItem():BelongsTo
    {
        return $this->belongsTo(OrderItems::class,'order_item_id')->withTrashed();
    }

    public function product():BelongsTo
    {
        return $this->belongsTo(Product::class,'product_id');
    }

    public function user():BelongsTo
    {
        return $this->belongsTo(User::class,'user_id');
    }
}
