<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CashWalletHistory extends Model
{
    use HasFactory;
    public $table = 'tbl_cash_wallet_history';
    public $guarded = [];

    public $appends = ['payment_method_name','status_name'];

    public function user(){
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function getPaymentMethodNameAttribute(){
        if($this->payment_method=='bkash'){
            return 'Bkash';
        }else if($this->payment_method=='rocket'){
            return 'Rocket';
        }else if($this->payment_method=='nagad'){
            return 'Nagad';
        }else if($this->payment_method=='wallet'){
            return 'Wallet';
        }
    }

    public function getStatusNameAttribute(){
        if($this->status==0){
            return 'Pending';
        }else if($this->status==2){
            return 'Rejected';
        }

        return null;
    }

    public function getStatusTextAttribute(){
        if($this->status==0){
            return 'Pending';
        }else if($this->status==1){
            return 'Accepted';
        }else if($this->status==2){
            return 'Rejected';
        }

        return null;
    }

}
