<?php

namespace App\Http\Requests\Seller;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ShopRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'shop_name_en'=>[
                'required',
                Rule::unique('tbl_shop', 'shop_name_en')->ignore(auth('seller')->id(), 'user_id'),
            ],
            'shop_name_bn'=>[
                'required',
                Rule::unique('tbl_shop', 'shop_name_bn')->ignore(auth('seller')->id(), 'user_id'),
            ],
            'shop_address'=>'required',
            'phone'=>'required',
            'lat'=>'required',
            'lon'=>'required',
        ];
    }
}
