<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DellerShopRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }
    public function rules()
    {
        if (Request()->has("id")) {
            return [
                "first_name"=>'required',
                "last_name"=>'required',
                "email"=>'required',
                "phone"=>'required',
                "status"=>'required',
                "shop_name_en" => "required",
                "shop_name_bn" => "required",
                "shop_address" => "required",
                "lat"=>'required',
                "lon"=>'required',
                "shop_status" => "required",
            ];
        } else {
            return [
                "first_name"=>'required',
                "last_name"=>'required',
                "email"=>'required',
                "phone"=>'required',
                "status"=>'required',
                "shop_name_en" => "required",
                "shop_name_bn" => "required",
                "shop_logo" => "required",
                "shop_address" => "required",
                "password"=>"required|min:8|max:20",
                "confirm_password"=>"required|same:password",
                "lat"=>'required',
                "lon"=>'required',
                "shop_status" => "required",
            ];
        }
    }
}
