<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class WithdrawRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator){
        throw new HttpResponseException(response()->json($validator->errors(),422));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'amount' => ['required','numeric','between:'.getValue('withdrawal_min_limit').','.getValue('withdrawal_max_limit')],
            'walletType' => ['required','in:cash_wallet,comission_wallet'],
            'type' => ['required','in:agent,perosnal'],
            'bkashNumber' => ['required'],
            'note' => ['required'],
        ];
    }
}
