<?php

namespace App\Http\Requests\Api;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Validation\Rule;
class RegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    protected function failedValidation(Validator $validator){
        throw new HttpResponseException(response()->json($validator->errors(),422));
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        $phone = '0'.request()->phone;
        return [
            'phone' => [
                'required',
                'size:10',
                Rule::unique('tbl_users', 'phone')->whereNotNull('phone_verified_at')->where('phone',$phone),
            ],
            'email' => [
                'nullable',
                'email:rfc,dns',
                Rule::unique('tbl_users', 'email')->whereNotNull('phone_verified_at'),
            ],
            'password' => 'required|min:8|max:20',
            'confirmPassword' => 'required|same:password',
            'referralCode' => 'nullable|exists:tbl_users,refer_token',
        ];

    }
}
