<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\AddMoneyRequest;
use App\Http\Requests\Api\WithdrawRequest;
use App\Models\AppSettings;
use App\Models\CashWalletHistory;
use App\Models\ComissionWalletHistory;
use App\Models\Notification;
use App\Models\ProductSubcategory;
use App\Models\User;
use App\Models\Withdrawal;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class WalletControler extends Controller
{
    public function getWithdarwalLimit(){
        return  response()->json([
            'min_amount'=>getValue('withdrawal_min_limit'),
            'max_amount'=>getValue('withdrawal_max_limit'),
            'charge'=>getValue('withdrawal_charge'),
        ]);
    }

    public function cashWalletHistory () {
        try{
            $user = auth()->user();
            $walletHistory = CashWalletHistory::select('id', 'amount', 'transaction_type','message',DB::raw('DATE_FORMAT(created_at,"%d %M %Y %H:%i") as date'),'payment_method','status')
            ->where('user_id', $user->id)->orderBy('updated_at','DESC')->get();
            $ballance = User::where('id', $user->id)->first('cash_wallet');

            return response()->json([
                "message" => "Cash wallet history Sent.",
                "data" => $walletHistory,
                "ballance" => $ballance->cash_wallet,
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function commissionWalletHistory () {
        try{
            $user = auth()->user();
            $commissionWalletHistory = ComissionWalletHistory::select('id', 'amount', 'message',DB::raw('DATE_FORMAT(created_at,"%d %M %Y %H:%i") as date'))
            ->where('user_id', $user->id)->orderBy('id','DESC')->get();
            $ballance = User::where('id', $user->id)->first('comission_wallet');

            return response()->json([
                "message" => "Commission wallet history Sent.",
                "data" => $commissionWalletHistory,
                "ballance" => $ballance->comission_wallet,
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function withdrawRequests () {
        try{
            $withdrawRequest = Withdrawal::selectRaw('*,DATE_FORMAT(created_at,"%d %M %Y %H:%i") as date')->orderBy('id','desc')->where('user_id', auth()->user()->id)->get();
            return response()->json(["data" => $withdrawRequest,], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function addMoneyFromBkashToWallet (AddMoneyRequest $request) {
        try{
            $user = auth()->user();
            // $ballance = User::where('id', $user->id)->first('cash_wallet');
            // User::where('id', $user->id)->increment('cash_wallet',$request->amount);

            CashWalletHistory::create([
                'user_id' => $user->id,
                'amount' => $request->amount,
                'phone'=> $request->phone,
                'transaction_type' => ADD_MONEY,
                'message'=>'Added by bkash',
                'transaction_id'=>$request->transactionId,
                'payment_method'=>$request->paymentMethod,
                'status'=>0,
                'current_balance'=>User::where('id', $user->id)->value('cash_wallet')
            ]);


            return response()->json([
                "message" => "Add money successful Sent.",
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function withdrawMoney (WithdrawRequest $request) {
        try{
            $user = auth()->user();
            $transactionId = 0;

            $ballance = User::select('cash_wallet', 'comission_wallet')->where('id', $user->id)->first();
            if(
                ($request->walletType == 'cash_wallet' && $ballance->cash_wallet < $request->amount) ||
                ($request->walletType == 'comission_wallet' && $ballance->comission_wallet < $request->amount)
            ){
                return response()->json([
                    'message' => "Insufficient ballance",
                ], 403);
            }

            $charge = getValue('withdrawal_charge');
            $amount = $request->amount+$charge;

            if($request->walletType == CASH_WALLET){
                User::where('id', $user->id)->decrement('cash_wallet', $amount);
                $transaction = CashWalletHistory::create([
                    'user_id' => $user->id,
                    'amount' => $amount,
                    'transaction_type' => 2,
                    'message' => $request->note,
                ]);
                $transactionId = $transaction->id;
            }else if($request->walletType == COMISSION_WALLET){
                User::where('id', $user->id)->decrement('comission_wallet', $amount);
                $transaction = ComissionWalletHistory::create([
                    'user_id' => $user->id,
                    'amount' => $amount,
                    'transaction_type' => 2,
                    'message' => $request->note,
                ]);
                $transactionId = $transaction->id;
            }

            $withdraw = Withdrawal::create([
                'user_id' => $user->id,
                'bkash_number' => $request->bkashNumber,
                'amount' => -$request->amount,
                'message' => 'Requested to withdraw money',
                'type' => $request->type,
                'charge' => $charge,
                'transaction_id' => $transactionId,
                'note' => $request->note,
                'wallet_type' => $request->walletType,
                'status' => 0,
            ]);



            return response()->json([
                "message" => "Withdraw successfull.",
                "ballance" => $withdraw
            ], 200);

        }catch (\Exception $e) {
            return response()->json([
                'message' => "Internal Server Error",
                'error' => $e->getMessage()
            ], 500);
        }
    }


    public function getWalletBalance(){
        $user = User::select('cash_wallet','comission_wallet')->where('id',Auth::user()->id)->first();
        return response()->json(['data'=>$user]);
    }

    public function getAddMoneyPaymentMethods(){
        $paymentMethods = [];
        $data = AppSettings::whereIn('tag',['bkash','nagad','rocket'])->get();

        foreach($data as $paymentMethod){
            if($paymentMethod->value){
                $name = null;
                $value = null;
                switch($paymentMethod->tag){
                    case 'bkash';
                        $name = 'Bkash';
                        $value = 'bkash';
                        break;
                    case 'nagad';
                        $name = 'Nagad';
                        $value = 'nagad';
                        break;
                    case 'rocket';
                        $name = 'Rocket';
                        $value = 'rocket';
                        break;
                }
                $paymentMethods[] = [
                    'name'=>$name,
                    'value'=>$value,
                    'number'=>$paymentMethod->value
                ];
            }
        }

        return response()->json(['success'=>true,'payment_methods'=>$paymentMethods],200);

    }
}
