<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Notification;
use App\Services\NotificationService;
use Illuminate\Http\Request;

class NotificationController extends Controller
{
    public function index(){
        $data = Notification::selectRaw("*, DATE_FORMAT(created_at, '%d %b %Y %H:%i') as date")->where('user_id',auth()->user()->id)->orderBy('id','DESC')->paginate(30);
        return response()->json(['notifications'=>$data->items(),'total_page'=>$data->total(),'current_page'=>$data->currentPage()]);
    }

    public function markAsRead(){
        // Notification::where('user_id',auth()->user()->id)->where('is_read',0)->update(['is_read'=>1]);
        return response()->json(['success'=>true,'message'=>'All Notifications marked as seen successfully']);
    }

    public function checkNotification(){
        $totalNotification = Notification::where('user_id',auth()->user()->id)->where('is_read',0)->count();
        return response()->json(['total_notification'=>$totalNotification]);
    }

    public function testNotification(){
        $token = 'ExponentPushToken[PwNKAHKMXOzv6QX2LExh2J]';
        $notification = ['title'=>'Test Notification','body'=>'This is a test notification'];
        NotificationService::sendNotification($token,$notification,['test'=>1]);
    }
}
