<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Models\AdminWallet;
use App\Models\CashWalletHistory;
use App\Models\ComissionWalletHistory;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class WalletController extends Controller
{
    public function comissionWalletHistory(){
        $data = ComissionWalletHistory::with('customer')->orderBy('id','DESC')->get();
        return view('admin.wallet-history.comission',compact('data'));
    }


    public function flashWallet(){
        $amount = AdminWallet::value('balance');
        $transactions = ComissionWalletHistory::where('for_admin',1)->get();
        return view('admin.wallet-history.flash-wallet',compact('amount','transactions'));
    }

    public function walletRequests(){
        $requests = CashWalletHistory::where('transaction_type',ADD_MONEY)->where('status',0)->get();
        return view('admin.wallet.request',compact('requests'));
    }


    public function changeStatus($id,$status){
        DB::beginTransaction();
        $request = CashWalletHistory::where('id',$id)->where('transaction_type',ADD_MONEY)->where('status',0)->first();
        if(!$request){
            abort(404);
        }
        $message = "Request has been rejected successfully";
        if($request->status == 1){
            User::where('id',$request->user_id)->increment('cash_wallet',$request->amount);
            $message = "Request has been accepted sucessfully";
        }

        $currentBalance = User::where('id',$request->user_id)->value('cash_wallet');

        $request->update(['status'=>$status,'current_balance'=>$currentBalance,'updated_at'=>Carbon::now()]);

        DB::commit();
        toastr()->success($message);
        return redirect()->back();
    }
}
