<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\ProductRequest;
use App\Models\Colors;
use App\Models\Product;
use App\Http\Controllers\Controller;
use App\Models\Brands;
use App\Models\Company;
use App\Models\Images;
use App\Models\ProductBasicInfo;
use App\Models\ProductCategory;
use App\Models\ProductColor;
use App\Models\ProductImages;
use App\Models\ProductSubcategory;
use App\Models\Seller;
use App\Models\SellerShop;
use App\Models\Shop;
use App\Models\Sizes;
use Illuminate\Support\Facades\Log;
use DB;
use Carbon\Carbon;

class ProductController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Product();
    }
    public function create()
    {
        $companies = Company::whereHas('brands')->get();
        $categories = ProductCategory::whereHas('basicProducts')->get();
        $products = ProductBasicInfo::with('thumbnails')->where('status',1)->whereNull('deleted_at')->get();
        $sizes = Sizes::all();
        $colors = Colors::all();
        $data=null;
        $subcategories=[];

        return view("admin.product.store",compact("categories", "companies",'sizes','colors','data','subcategories','products'));
    }

    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();

        $categories = ProductCategory::whereHas('products')->get();
        $subcategories = ProductSubcategory::whereHas('products')->get();
        $brands = Brands::whereHas('products')->get();
        $companies = Company::whereHas('products')->get();
        $shops = Shop::whereHas('user',function($query){
                    $query->where('role',SELLER);
                })->whereHas('products')->get();
        $products = Product::withWhereHas('basicInfo')->filter()->orderBy("id", $sort)->get();
        return view("admin.product.list", compact("products","categories","subcategories","brands","companies","products","shops"));
    }


    public function edit($id)
    {
        $data = Product::filter()->with(['thumbnailImage','images.image','colors'])->findOrFail($id);
        if(!$data){
            abort(404);
        }
        // $role = $data->user->role;
        $companies = Company::whereHas('brands')->get();
        $categories = ProductCategory::whereHas('basicProducts')->get();
        $subcategories = ProductSubcategory::where('category_id',$data->category_id)->get();
        $products=[];



        // $image = Images::where('id',$data->thumbnail)->first();
        // $data->thumbnail_image_url = $image->file_url;


        $selctedImages  = $data->images?->map(function($image){
            return [
                'id'=>$image->id,
                'file_url'=>$image?->image?->file_url,
                'file_path'=>$image?->image?->file_path
            ];
        });

        $data->_images = $selctedImages;


        $sizes = Sizes::all();
        $selectedColors = $data->colors?->pluck('color_id')->toArray();
        $colors = Colors::whereNotIn('id',$selectedColors)->get();
        $basicInfo = ProductBasicInfo::where('id',$data->basic_info_id)->first();
        return view(
            "admin.product.store",
            compact("data", "categories","companies","subcategories","sizes","colors","basicInfo","data","products")
        );
    }

    public function view($id)
    {
        $data = Product::where("id", $id)->first();
        return view("admin.product.view", compact("data"));
    }

    public function details($id){
        $product = ProductBasicInfo::select('*')
                ->where('status',1)
                ->with(['thumbnails','images'])
                ->filter()
                ->findOrFail($id);
        $brands = Brands::where('status',ACTIVE)->get();
        $subcategories = ProductSubcategory::select('id','subcategory_name_en')->where('category_id',$product->category_id)->where('status',ACTIVE)->get();
        $products = ProductBasicInfo::select('*')
                ->where('status',1)
                ->with(['thumbnails','images'])
                ->where('category_id',$product->category_id)
                ->where('subcategory_id',$product->subcategory_id)
                ->where('company_id',$product->company_id)
                ->filter()
                ->get();
        return response()->json(['product'=>$product,'brands'=>$brands,'subcategories'=>$subcategories,'products'=>$products]);
    }

    public function store(ProductRequest $request)
    {
        DB::beginTransaction();
        try {
            // $isExist = Product::filter()->where('basic_info_id',$basic_info_id)->where('shop_id',$request->shop_id)->first();
            // if($isExist && !$request->id){
            //     toastr()->warning('This shop already has this  product');
            //     return redirect()->back();
            // }
            // $user_id = Shop::where('id',$request->shop_id)->value('user_id');
            $productBasicInfo = ProductBasicInfo::where('id',$request->product_id)->first();
            if(request()->has('id')){
                $comission = (float)$request->spot_comission +  $request->team_comission;
                if($comission > 100){
                    toastr()->error("Comission can't be set more than 100%");
                    return redirect()->back();
                }
            }
            $data = [
                'category_id'=>$request->category_id,
                'subcategory_id'=>$request->subcategory_id,
                'company_id'=>$request->company,
                'brand_id'=>$request->brand_id,
                'product_name_en'=>$productBasicInfo->product_name_en,
                'product_name_bn'=>$productBasicInfo->product_name_bn,
                'thumbnail'=>$request->thumbnail,

                "basic_info_id" => $request->product_id,

                "original_price" => $request->original_price,
                "sale_price" => $request->sale_price,
                "warranty_time"=>$request->warranty_time,
                "refund_time"=>$request->refund_time,
                "sizes"=>$request->sizes ? implode(',',$request->sizes):'',
                "customer_discount"=> $request->customer_discount,
                "agent_discount" => $request->agent_discount,


                "spot_comission"=>$request->spot_comission,
                "team_comission"=>$request->team_comission,

                "dropshipper_discount" => $request->dropshipper_discount,
                "dropshipper_min_price" => $request->dropshipper_min_price,
                "dropshipper_max_price" => $request->dropshipper_max_price,
                "dropshipper_pre_payment" => $request->dropshipper_pre_payment,

                "is_featured"=>$request->is_featured,
                "show_in_home"=>$request->show_in_home,
                "status" => $request->status,
                'stock'=>$request->stock,

                'is_free_delivery'=>$request->is_free_delivery=='on'?1:0,
                'free_delivery_quantity'=>$request->free_delivery_quantity,
                'tag'=>$request->tag,

                'details_one_title'=>$request->details_one_title,
                'details_two_title'=>$request->details_two_title,
                'details_three_title'=>$request->details_three_title,

                'details_one'=>$request->details_one,
                'details_two'=>$request->details_two,
                'details_three'=>$request->details_three,
            ];

            if ($request->has("id")) {
                Product::where("id", $request->id)->update($data);
                $productId = $request->id;
            } else {
                $data['shop_id'] = 1;
                $data['user_id'] = 1;
                $product = Product::create($data);
                $productId = $product->id;
            }

            ProductImages::where('product_id',$productId)->delete();
            $images = json_decode($request->images);
            foreach($images as $image){
                ProductImages::insert([
                    'image_id'=>$image->id,
                    'product_id'=>$productId,
                ]);
            }

            $productColors = [];
            $colorImages = $request->color_images ?? [];
            foreach($colorImages as $key=>$image){
                $filePath = imageUpload($image, '/product/colors/');
                $productColors[] = [
                    'image' => $filePath,
                    'product_id'=>$productId,
                    'color_id'=>$request->color_ids[$key]
                ];
            }

            ProductColor::insert($productColors);
            DB::commit();
            toastr()->success('Product info has been saved successfully');
            return redirect()->route('product.edit',['id'=>$productId]);
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Product -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function selectProduct(){
        $products = ProductBasicInfo::get();
        return view('admin.product.select-product',compact('products'));
    }

    public function delete($id)
    {
        Product::where("id", $id)->update(["deleted_at" => Carbon::now()]);
        return redirect()->back()->with("success", "Data Deleted Successfully");
    }

    public function deleteColor($id){
        ProductColor::where('id',$id)->delete();
        toastr()->success('Color has been deleted successfully');
        return redirect()->back();
    }
}
