<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\GroupProductRequest;
use App\Models\GroupProduct;
use App\Models\Product;
use Illuminate\Http\Request;

class GroupProductController extends Controller
{
    public function index(){
        // Fetch all group products
        $groupProducts = GroupProduct::get();
        return view('admin.group-products.index', compact('groupProducts'));
    }

    public function create(){
        // Show the form to create a new group product
        $products = Product::with(['shop'])->where('status',ACTIVE)->whereHas('user')->whereHas('basicInfo')->get();
        $data = null;
        $selectedProducts = [];
        return view('admin.group-products.form',compact("products","data","selectedProducts"));
    }

    public function edit($id){
        $products = Product::with(['shop'])->where('status',ACTIVE)->whereHas('user')->whereHas('basicInfo')->get();
        $data = GroupProduct::findOrFail($id);
        $selectedProducts = $data->product_ids;
        return view('admin.group-products.form',compact("products","data","selectedProducts"));
    }

    public function delete($id){
        // Delete the group product
        $groupProduct = GroupProduct::findOrFail($id);
        $groupProduct->delete();
        toastr()->success('Group Product deleted successfully');
        return redirect()->route('group-product.index');
    }

    public function store(GroupProductRequest $groupProductRequest){
        $id = request('id');
        $data =  [
            'name_en'=>$groupProductRequest->name_en,
            'name_bn'=>$groupProductRequest->name_bn,
            'product_ids'=>$groupProductRequest->product_ids,
            'status'=>$groupProductRequest->status
        ];

        if($groupProductRequest->hasFile('icon')){
            $data['icon'] = imageUpload($groupProductRequest->file('icon'),'/group_product/');
        }



        GroupProduct::updateOrCreate(['id'=>$id],$data);
        toastr()->success('Group products has been save successfully');
        return redirect()->route('group-product.index');
    }
}
