<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\ChangePasswordRequest;
use App\Models\User;
use Illuminate\Http\Request;
use DB;
use Hash;

class GlobalController extends Controller
{
    public function changeStatus($table,$id,$status){
        DB::table($table)->where('id',$id)->update(['status'=>$status]);
        flash()->success('Status has been changed successfully');
        return redirect()->back();
    }

    public function changePasswordForm(){
        return view('auth.change-password');
    }

    public function changePassword(ChangePasswordRequest $request){
        $userId = auth()->user()->id;
        $user = User::where('id',$userId)->first();
        if($user){
            if(Hash::check($request->old_password,$user->password)){
                $user->update(['password'=>Hash::make($request->new_password)]);
                flash()->success('Password chaged successfully');
            }else{
                flash()->error('Sorry ! Invalid old password');
            }
        }else{
            flash()->error('Sorry ! we dont found any user , please login again');
        }
        return redirect()->back();
    }
}
