<?php
namespace App\Http\Controllers\admin;
use App\Http\Requests\DellerShopRequest;
use App\Models\DellerShop;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Log;
use DB;

class DellerShopController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new DellerShop();
    }
    public function create()
    {
        return view("admin.deller.form");
    }
    public function list()
    {
        $sort = request("sort") ? request("sort") : "DESC";
        $limit = request("limit") ? request("limit") : defaultLimit();
        $data = DellerShop::orderBy("id", $sort);
        if ($limit) {
            $data = $data->paginate($limit);
        } else {
            $data = $data->get();
        }
        return view("admin.deller.list", compact("data"));
    }
    public function edit($id)
    {
        $data = DellerShop::where("id", $id)->first();
        return view("admin.deller.edit", compact("data"));
    }
    public function view($id)
    {
        $data = DellerShop::where("id", $id)->first();
        return view("admin.deller.view", compact("data"));
    }

    public function store(DellerShopRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "dealer_id" => $request->dealer_id,
                "shop_name_en" => $request->shop_name_en,
                "shop_name_bn" => $request->shop_name_bn,
                "shop_address" => $request->shop_address,
                "status" => $request->status,
            ];
            if ($request->hasFile("shop_logo")) {
                if ($request->has("id")) {
                    $shop_logo = DellerShop::where("id", $request->id)->value(
                        "shop_logo"
                    );
                    if ($shop_logo) {
                        deleteImage("", $shop_logo);
                    }
                }
                $shop_logo = imageUpload(
                    $request->file("shop_logo"),
                    Constant::DELLERSHOP
                );
                $data["shop_logo"] = $shop_logo;
            }
            if ($request->has("id")) {
                DellerShop::where("id", $request->id)->update($data);
                $text = "updated";
            } else {
                DellerShop::insert($data);
                $text = "created";
            }
            DB::commit();
            return redirect()
                ->back()
                ->with(
                    "success",
                    "deller_shop has been " . $text . " successfully"
                );
        } catch (\Exception $e) {
            DB::rollback();
            Log::error("Dellershop -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        DellerShop::where("id", $id)->update(["deleted_at" => Carbon::now()]);
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
