<?php
namespace App\Http\Controllers\admin;
use App\Enums\Constant;
use App\Http\Requests\BannerRequest;
use App\Models\Banner;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\ProductCategory;
use App\Models\Shop;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class BannerController extends Controller
{
    public $model;
    public function __construct()
    {
        $this->model = new Banner();
    }
    public function create()
    {
        $categories = ProductCategory::all();
        $shops = Shop::all();
        return view("admin.banner.store",compact('categories','shops'));
    }

    public function appPopup()
    {
        $data = Banner::findOrFail(0);
        $categories = ProductCategory::all();
        $shops = Shop::all();
        return view("admin.banner.store", compact("data","shops","categories"));
    }

    public function list()
    {
        $data = Banner::where('id','>',0)->latest()->get();
        return view("admin.banner.list", compact("data"));
    }
    
    public function edit($id)
    {
        $data = Banner::findOrFail($id);
        $categories = ProductCategory::all();
        $shops = Shop::all();
        return view("admin.banner.store", compact("data","shops","categories"));
    }

    public function view($id)
    {
        $data = Banner::findOrFail($id);
        return view("admin.banner.view", compact("data"));
    }

    public function store(BannerRequest $request)
    {
        DB::beginTransaction();
        try {
            $data = [
                "type" => $request->type,
                "link" => $request->link,
                "status" => $request->status,
                'publish_at'=> $request->publish_at,
                'unpublish_at'=> $request->unpublish_at,
            ];

            if ($request->hasFile("banner_image")) {
                if ($request->has("id")) {
                    $banner_image = Banner::where("id", $request->id)->value(
                        "banner_image"
                    );
                    if ($banner_image) {
                        deleteImage("", $banner_image);
                    }
                }
                $banner_image = imageUpload(
                    $request->file("banner_image"),
                    '/banner/'
                );
                $data["banner_image"] = $banner_image;
            }
            Banner::updateOrCreate(['id'=>$request->id],$data);
            DB::commit();
            return redirect()->back()->with("success", "banner has been saved successfully");
        } catch (\Exception $e) {
            return $e;
            DB::rollback();
            Log::error("Banner -> store : " . $e->getMessage());
            return serverError();
        }
    }

    public function delete($id)
    {
        Banner::where("id", $id)->delete();
        return redirect()
            ->back()
            ->with("success", "Data Deleted Successfully");
    }
}
