<?php

namespace App\Http\Controllers\Shared;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
     public function loginForm(){
        return view('auth.login');
    }


    public function login(Request $request){
        //add role when we will have different types of subdomain
        $auth = Auth::guard('user')->attempt(['email'=>$request->email,'password'=>$request->password,'status'=>ACTIVE]);
        if($auth){
            toastr()->success('Welcome to the deller panel');
            return redirect()->route(getDashboardLink());
        }else{
            toastr()->error('Sorry ! invalid email or password');
            return redirect()->back();
        }
    }

    public function logout(){
        auth('user')->logout();
        return redirect()->route('auth.login.form');
    }
}
