<?php

namespace App\Http\Controllers\Auth;

// use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use App\Http\Requests\Api\LoginRequest;
use App\Http\Requests\Api\LoginVerificationRequest;
use App\Http\Requests\Api\RegisterRequest;
use App\Http\Requests\Api\UpdateProfileRequest;
use App\Mail\VerificationMail;
use App\Models\Notification;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class AuthController extends Controller{

    public function signIn(LoginRequest $request): JsonResponse
    {
        try{
            $user = User::where('phone', $request->phone)->whereNotNull('phone_verified_at')->whereNull('deleted_at')->first();
            if($user){
                $otpLastGeneratedAt = Carbon::parse($user->otp_last_generated_at);
                $currentDateTime = Carbon::now();
                $timeDifference = $currentDateTime->diffInMinutes($otpLastGeneratedAt);
                $data = [];
                if($timeDifference > 5){
                    $otp = str_pad(rand(0, 9999), 4, '0', STR_PAD_LEFT);
                    $data['otp']=$otp;
                    $data['otp_last_generated_at']=Carbon::now();
                    $user->update($data);

                    $message = 'Your Otp Is '.$otp.' From Ezone . Please Visit https://admin.robiulawal.xyz';
                    Notification::sendSms($message,'0'.$request->phone);
                    return response()->json([
                        'message' => "We sent an otp to your phone",
                    ], 200);
                }else{
                    return response()->json([
                        'message' => "We already sent an otp to your phone",
                    ], 200);
                }

            }else{
                return response()->json(['success'=>false,'message'=>'Sorry ! No Account Found'],400);
            }
        }catch(\Exception $e){
            return response()->json([
                'message' => 'Internal Server Error',
            ], 500);
        }
    }

    public function signUp(RegisterRequest $request)
    {
        try {
            $otp = random_int(1000, 9999);
            $cuttentTime = Carbon::now();
            $uuid = rand(000000,111111);
            $parentId = 0;


            if($request->referralCode){
                $parant = User::select('id')->where('refer_token', $request->referralCode)->first();

                if(!$parant){
                    return response()->json([
                        'success' => false,
                        'message' => "Referral code is not correct.",
                    ], 409);
                }

                $parentId = $parant->id;
            }

            $user = User::updateOrCreate(['phone'=>$request->phone],[
                'phone' => $request->phone,
                'otp' => $otp,
                'otp_last_generated_at' => $cuttentTime,
                'parent_id' => $parentId ? $parentId : NULL,
                'refer_token' => $uuid,
                'role'=>CUSTOMER
            ]);

            $message = 'Your Otp Is '.$otp.' From Ezone . Please Visit https://admin.robiulawal.xyz';
            Notification::sendSms($message,'0'.$request->phone);
            return response()->json([
                'message' => "We sent an otp to your phone",
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
            ], 500);
        }
    }

    public function logout(Request $request)
    {
        try {
            Auth::guard('web')->logout();

            $request->user()->token()->revoke();

            return response()->json([
                'message' => "User Logged Out.",
            ], 200); // 200 ok

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
            ], 500);
        }
    }

    public function showVerificationPage()
    {
        // $email = session('phone');
        // if (!$email) {
        //     return redirect()->route('show-login');
        // }

        return view('auth.verification');
    }

    public function generateOtp(Request $request)
    {
        try{
            $six_digit_random_number = random_int(1000, 9999);
            $cuttentTime = Carbon::now();

            $user = User::where('phone', $request->query('phone'))->first();

            if($user) {
                $timeForNewOtp = Carbon::parse($user->otp_last_generated_at)->addMinute(2);
                    if(!$timeForNewOtp->isPast()){
                        return response()->json([
                            'message' => "We alrady sent an OTP to your phone.",
                            'error' => "We alrady sent an OTP to your phone.",
                        ], 403); // Status code 401
                    }
                $user->update([
                    'otp' => $six_digit_random_number,
                    'otp_last_generated_at' => $cuttentTime,
                ]);
                $user->save();
                Mail::to($user->phone)->send(new VerificationMail($six_digit_random_number));

                return response()->json([
                    'message' => "New OTP sent.",
                ], 200); // 200 ok
            }else{
                return response()->json([
                    'message' => "Wrong credential.",
                    'error' => "Wrong credential.",
                ], 401); // Status code 401
            }
        }catch (\Exception $e) {
            return response()->json([
                'error' => 'Internal Server Error',
                'message' => 'Internal Server Error',
                // 'err' => $e
            ], 500);
        }
    }

    public function verifyPhone(LoginVerificationRequest $request)
    {
        try{
            $user = User::where('phone', $request->phone)->first();

            if($request->otp == $user->otp){
                $expiresAt = Carbon::parse($user->otp_last_generated_at)->addMinute(60 * 24 * 30);  // 1 month
                if($expiresAt->isPast()){
                    return response()->json([
                        'message' => "We alrady sent an OTP to your phone.",
                    ], 403); // Status code 403
                }

                $user->update([
                    'phone_verified_at' => Carbon::now(),
                    'team_parent_id'=>$user->parent_id?$this->findTeamParentId($user->parent_id):null,
                ]);

                $userData = [
                    'first_name' => $user->first_name,
                    'last_name' => $user->last_name,
                    'phone' => $user->phone,
                    'email' => $user->email,
                ];

                if($user->currentAccessToken()){
                    $user->currentAccessToken()->delete();
                }

                $tokenExpiresAt = Carbon::now()->addDays(30);
                $tokenName = Str::random(12).time();
                // Create new token
                $token = $user->createToken($tokenName, ['*'], $tokenExpiresAt);

                Auth::login($user);


                return response()->json([
                    'message' => "User phone is verified.",
                    'token' => $token->plainTextToken,
                    'data' => $userData,
                    'referCode'=>$user->refer_token,
                ], 200); // 200 ok
            }
            else{
                return response()->json([
                    'message' => "Invalid OTP Provided. Email Verification Failed!",
                    'verified' => 0,
                ], 409); // Status code 409
            }

        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
                'error' => 'Internal Server Error',
                // 'err' => $e
            ], 500);
        }
    }

    public function updateProfile(UpdateProfileRequest $request)
    {
        try{
            $user = auth()->user();
            User::where('id', $user->id)->update([
                "first_name" => $request->firstName,
                "last_name" => $request->lastName,
                "email" => $request->email,
                "delivery_lat"=>$request->delivery_lat,
                "delivery_lon"=>$request->delivery_lon,
                "address"=>$request->address,
                // "phone" => $request->phone,
            ]);

            return response()->json([
                'message' => 'Profile Updated Successfully',
                // 'data' => $userUpdate,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
                'error' => 'Internal Server Error',
                'err' => $e
            ], 500);
        }
    }

    public function userDetails()
    {
        try{
            $user = auth()->user();
            $userDetails = User::select('first_name', 'last_name', 'email', 'phone','delivery_lat','delivery_lon','address')->where('id', $user->id)->first();

            return response()->json([
                'message' => 'User Details Sent.',
                'data' => $userDetails,
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Internal Server Error',
                // 'err' => $e
            ], 500);
        }
    }


    public function getReferrals(){
        $level = 1;
        $id = Auth::user()->id;
        $userId = [$id];
        $referralChain = collect();
        $user=User::where('id',$id)->first();

        // return response()->json(['data'=>$referralChain]);


        for ($i = 1; $i < 25; $i++) {
            $users = User::select('id','first_name','last_name','phone','parent_id')->whereIn('parent_id',$userId)->where('role',CUSTOMER)->get();
            if ($users->isEmpty()) {
                break; // Break the loop if no users found at this level
            }

            $level = [
                'label'=>'Level '.$i,
                'users'=>$users
            ];

            $referralChain->push($level);

            $userId = $users->pluck('id')->toArray();
        }

    }


    public function test(){
        $user = User::select('id','first_name','last_name')
        ->with('team.team.team')
        ->where('id',57)->first();
        return response()->json(['user'=>$user]);
    }

    public function findTeamParentId($refferId){
        $user = User::select('id','first_name','last_name')
            ->with('team.team')
            ->where('id',$refferId)->first();

        $teamParentId = $user->id;
        $maxLevelUser = maxLevelUser();

        if($user->team?->count() >= $maxLevelUser){
            $team  = $user->team;
            $isFreeSlotFound = false;

            for($i=1;$i<=$maxLevelUser;$i++){
                foreach($team as $teamMember){
                    $refferedBySameUser = $teamMember?->team?->where('parent_id',$refferId)->count();
                    if($teamMember->team?->count() < $maxLevelUser && $refferedBySameUser < $i){
                        $teamParentId = $teamMember->id;
                        $isFreeSlotFound = true;
                    }

                    if($isFreeSlotFound)
                        break;
                }

                if($isFreeSlotFound)
                    break;

                if($i==$maxLevelUser && !$isFreeSlotFound){
                    $team = $team->flatMap(function ($teamA) {
                        return $teamA->team;  // Assuming 'team' contains the sub-teams (teamB)
                    });
                    $i=0;
                }
            }
        }

        return $teamParentId;
    }

}
