
<?php $__env->startSection('content'); ?>
<style>
    p{
        margin-bottom: 1px;
        font-family: 'Rubik';
        font-weight: 400;
        text-align: left;
    }
    span{
        color: #ccc;
    }

</style>
<div class="mi-card">
    <div class="mi-header info"> <?php echo e(orderPageTitle()); ?> </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>ORDER NUMBER</th>
                    <th>QTY</th>
                    <th>CUSTOMER INFO</th>
                    <th>PAYMENT METHOD</th>
                    <th>ORDER TOTAL</th>
                    <th>STATUS</th>
                    <th>ACTION</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($order->id); ?></td>
                    <td>
                        <p><span>Number:</span> <?php echo e($order->order_number); ?></p>
                        <p><span>date:</span> <?php echo e(date('Y M d',strtotime($order->created_at))); ?></p>
                    </td>
                    <td class="center"><?php echo e($order->qty); ?></td>
                    <td>
                        <p><span>Name: </span><?php echo e(optional($order->user)->first_name); ?> <?php echo e(optional($order->user)->last_name); ?></p>
                        <p><span>Phone: </span><?php echo e(optional($order->user)->phone); ?></p>
                    </td>
                    <td class="center">
                        <?php echo e(getPaymentMethod($order->payment_method)); ?>

                    </td>
                    <td>
                        <p><span>Total: </span>৳ <?php echo e($order->order_total+$order->tax+$order->delivery_charge); ?></p>
                        <p><span>Discount: </span>-৳ <?php echo e($order->discount_amount); ?></p>
                    </td>
                    <td class="center">
                        <?php echo getStatusWithColor($order->status); ?>

                    </td>
                    <td>
                        <a href="<?php echo e(route('order.view',['id'=>$order->id])); ?>"><button class="butn info transparent butn-sm "><i class="fa fa-eye"></i></button></a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/robiulaw/public_html/resources/views/admin/order/list.blade.php ENDPATH**/ ?>