<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header">
        FUND REQUESTS
        <a href="<?php echo e(route('hub.fund.create')); ?>" class="mi-right butn success">MAKE A NEW REQUEST</a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th style="text-align:center">#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Details</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($request->id); ?></td>
                        <td><?php echo e(Carbon\Carbon::parse($request->date)->format('d M Y')); ?></td>
                        <td><?php echo e($request->amount); ?></td>
                        <td><?php echo e(Str::limit($request->description, 20, '...')); ?></td>
                        <td><?php echo e($request->status_text); ?></td>
                        <td>
                            <?php if($request->status == FUND_REQUEST_PENDING): ?>
                                <a href="<?php echo e(route('hub.fund.edit', ['id' => $request->id])); ?>"><button class="butn warning butn-sm"><i class="fa fa-edit"></i></button></a>
                                <a onclick="deleteconfirm('<?php echo e(route('hub.fund.delete', ['id' => $request->id])); ?>')"><button class="butn danger butn-sm"><i class="fa fa-trash"></i></button></a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('hub.theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/hub/fund/index.blade.php ENDPATH**/ ?>