<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header info">
        All Ranks
        <a href="<?php echo e(route('admin.rank.create')); ?>">
            <button class="butn success mi-right">Add Rank</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Rank Name</th>
                    <th>Type</th>
                    <th>Team A Amount</th>
                    <th>Team B Amount</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $ranks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($rank->id); ?></td>
                        <td><?php echo e($rank->name); ?></td>
                        <td><?php echo e(getRankTypes()[$rank->type]); ?></td>
                        <td><?php echo e($rank->team_A_amount); ?></td>
                        <td><?php echo e($rank->team_B_amount); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.rank.edit', ['id' => $rank->id])); ?>">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('<?php echo e(route('admin.rank.delete', ['id' => $rank->id])); ?>','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/admin/rank/index.blade.php ENDPATH**/ ?>