<!DOCTYPE html>
<html lang="en" data-theme="mi-light">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MI DESIGN</title>
    <link href="<?php echo e(asset('css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.0/css/all.min.css" rel="stylesheet">
    <link href="<?php echo e(asset('css/sidebar.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('font/flaticon_ezone.css')); ?>">
    <script src="https://cdn.ckeditor.com/ckeditor5/37.0.1/classic/ckeditor.js"></script>
    <link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet" />
    <script src="<?php echo e(asset('js/jquery.min.js')); ?>"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.css">
    <script type="text/javascript" charset="utf8" src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.js"></script>

    
    <input type="hidden" name="params" id="_params" value="<?php echo e(json_encode(request()->request->all())); ?>">
    <?php echo app('Illuminate\Foundation\Vite')('resources/js/app.js'); ?>
    <?php echo \Livewire\Livewire::styles(); ?>

</head>
</head>


<div class="mi-loader d-none">
    <div class="loader m-auto"></div>
</div>

<body>

    <div aria-live="polite" aria-atomic="true" class="position-relative">
        <div class="toast-container position-absolute top-0 end-0 p-3" style="z-index: 999">
            <!-- Then put toasts within -->
            <?php $__currentLoopData = $errors?->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="toast" role="alert" aria-live="assertive" aria-atomic="true">
                <div class="toast-header danger">
                    <strong class="me-auto">Validation error</strong>
                    <small class="text-white">just now</small>
                    <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
                </div>
                <div class="toast-body" style="background: #ffff;font-family: 'Rubik';font-weight: 600;font-size: 15px;">
                    <?php echo e($error); ?>

                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php echo $__env->make('theme.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('theme.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="container-fluid">
        <div class="row mi-light-theme">
            <div class="mi-sidebar mi-collapse">
                <?php echo $__env->make('theme.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="mi-content">
                <div class="w-100">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>


    <?php echo \Livewire\Livewire::scripts(); ?>

    <script src="<?php echo e(asset('js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>

    <script src="<?php echo e(asset('js/theme.js')); ?>"></script>
    <script>
        $(document).ready(function(){
            // let ClassicEditor;
            $('select').select2();
            $('#company').select2({
                tags:true
            });

            ClassicEditor.create(document.querySelector('#editor'), {

            })
            .then((newEditor) => {
                editor = newEditor;
            })
            .catch((error) => {
                console.error(error);
            });
        })

    </script>

<script>
    $(document).ready(function () {
        $('#dataTable').DataTable({
            "dom": '<"top"lfB<"clear">>rt<"bottom"ip<"clear">>',
            "buttons": [
                'copy', 'csv', 'excel', 'pdf', 'print'
            ],
            "order": [],
        });

        // $('.select2').select2();
    });
</script>

<?php if($errors?->any()): ?>
<script>
    $(document).ready(function(){
        $('.toast').toast('show')
    })
</script>
<?php endif; ?>

</body>

</html>
<?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/theme/theme.blade.php ENDPATH**/ ?>