<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-sm-8 m-auto">
        <div class="mi-card">
            <div class="mi-header success"><?php echo e($data?'Edit Group Products':'Add Product Groups'); ?></div>
            <form action="<?php echo e(route('group-product.store',['id'=>$data?->id])); ?>" method="post" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="mi-body">
                    <div class="row">
                        <div class="col-sm-6 form-group">
                            <label for="">Name (English) <b class="text-danger">*</b></label>
                            <input type="text" name="name_en" id="name_en" class="form-control" value="<?php echo e($data?->name_en); ?>" required>
                        </div>
                        <div class="col-sm-6 form-group">
                            <label for="">Name (Bangla)</label>
                            <input type="text" name="name_bn" id="name_bn" class="form-control" value="<?php echo e($data?->name_bn); ?>">
                        </div>
                        <div class="form-group position-relative col-sm-6">
                            <label>Icon <b class="text-danger">*</b>
                            </label> <?php if(isset($data)): ?> <div class="edit-image" style="width:100px !important">
                            <a href="<?php echo e($data->icon_url); ?>">
                                <img src="<?php echo e($data->icon_url); ?>" alt="">
                            </a>
                            </div> <?php endif; ?> <input type="file" name="icon" id="icon" class="form-control <?php echo e(isset($data)?'edit-input':''); ?> ">
                        </div>
                        <div class="col-sm-6 form-group m-auto">
                            <label for="">Status</label>
                            <select name="status" id="status" class="form-control">
                                <option value="1" <?php echo e($data?->id==1?'selected':''); ?>>Active</option>
                                <option value="0" <?php echo e($data?->id==0?'selected':''); ?>>Inactive</option>
                            </select>
                        </div>
                        <div class="col-sm-12 form-group">
                            <label for="">Select Products</label>
                            <select name="product_ids[]" multiple id="product_ids" class="form-control" placeholder="Select Products">
                                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($product->id); ?>" <?php echo e(in_array($product->id,$selectedProducts)?'selected':''); ?>><?php echo e($product->product_name_en); ?> - (<?php echo e($product?->shop?->name); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success"><?php echo e($data?'Update':'Create'); ?></button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/admin/group-products/form.blade.php ENDPATH**/ ?>