
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-sm-8 m-auto">
            <div class="mi-card">
                <!--start of mi-fc-card-->
                <div class="mi-header <?php echo e($status); ?> ">
                    <!--mi card header started--><?php echo e($title); ?> BANNER
                </div>
                <!--end of mi card header-->
                <form action="<?php echo e(route('banner.store')); ?>" method="POST" enctype="multipart/form-data">
                    <div class="mi-body" id="app">
                        <!--mi-card body started-->
                        <input name="_token" type="hidden" value="<?php echo e(csrf_token()); ?>">
                        <input name="id" type="hidden" value="<?php echo e($data?->id); ?>">
                        <div class="row">
                            <div class="form-group position-relative">
                                <label>BANNER IMAGE <b class="text-danger"><?php if($data?->id>0): ?>(WIDTH:800 & HEIGHT:300)<?php endif; ?>*</b></label>
                                <?php if($data?->banner_image): ?>
                                    <div class="edit-image">
                                        <a href="<?php echo e(asset('images' . $data?->banner_image)); ?>">
                                            <img src="<?php echo e(asset('images' . $data?->banner_image)); ?>" alt="">
                                        </a>
                                    </div>
                                <?php endif; ?>
                                <input type="file" name="banner_image" id="banner_image"
                                    class="form-control <?php echo e($image_class); ?> ">
                            </div>
                            <div class="form-group">
                                <label>TYPE <b class="text-danger">*</b>
                                </label>
                                <select class="form-control" id="type" name="type" required>
                                    <option value="1" <?php echo e($data?->type == 1 ? 'Selected' : ''); ?>>Category</option>
                                    <option value="2" <?php echo e($data?->type == 2 ? 'Selected' : ''); ?>>Shop</option>
                                    <option value="3" <?php echo e($data?->type == 3 ? 'Selected' : ''); ?>>Link</option>
                                </select>
                            </div>
                            <div v-if="banner_type == 1">
                                <div class="form-group">
                                    <label>Category <b class="text-danger">*</b></label>
                                    <select name="link" id="link" class="form-control" required>
                                        <option value="">SELECT CATEGORY</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($category->id); ?>" <?php echo e($category->id == $data?->link?'selected':''); ?>><?php echo e($category->category_name_en); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div v-if="banner_type == 2">
                                <div class="form-group">
                                    <label>Shop <b class="text-danger">*</b></label>
                                    <select name="link" id="link" class="form-control" required>
                                        <option value="">SELECT SHOP</option>
                                        <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($shop->id); ?>" <?php echo e($shop->id == $data?->link?'selected':''); ?>><?php echo e($shop->shop_name_en); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div v-if="banner_type == 3">
                                <div class="form-group">
                                    <label>Link <b class="text-danger">*</b></label>
                                    <input type="text" placeholder="LINK" name="link" id="link" class="form-control"
                                        value="<?php echo e(old('link') ?? $data?->link); ?>" required>
                                </div>
                            </div>

                            <div class="row ps-0 pe-0">
                                <div class="form-group col-sm-6">
                                    <label>PUBLISH DATE </label>
                                    <input type="datetime-local" name="publish_at" id="publish_at" class="form-control"
                                        value="<?php echo e(old('publish_at') ?? $data?->publish_at); ?>">
                                </div>
                                <div class="form-group col-sm-6">
                                    <label>UNPUBLISH DATE </label>
                                    <input type="datetime-local" name="unpublish_at" id="unpublish_at" class="form-control"
                                        value="<?php echo e(old('unpublish_at') ?? $data?->unpublish_at); ?>">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>STATUS <b class="text-danger">*</b>
                                </label>
                                <select class="form-control" id="status" name="status" required>
                                    <option selected>SELECT ONE </option>
                                    <option value="1" <?php echo e($data?->status == 1 ? 'Selected' : ''); ?>>
                                        Publish
                                    </option>
                                    <option value="0" <?php echo e($data?->status == 0 ? 'Selected' : ''); ?>>Hide
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <!--end of mi-card-body-->
                    <div class="mi-footer">
                        <!--mi-card footer started-->
                        <div class="row">
                            <div class="col-sm-4 m-auto">
                                <button type="submit" class="butn <?php echo e($status); ?> w-100"> <?php echo e($button_name); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                    <!--end of mi-card-footer-->
                </form>
            </div>
            <!--end of mi-fc-card-->
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                banner_type:1
            },
            mounted(){
                const type = <?php echo json_encode($data?->type, 15, 512) ?>;
                if(type){
                    this.banner_type = type;
                }
                $('#type').on('change', this.setBannerType);
            },
            methods: {
                setBannerType(){
                    const type = $('#type').val();
                    this.banner_type = type;
                    if(type == 1 || type == 2){
                        setTimeout(() => {
                            $('#link').select2();
                        }, 300);
                    }
                }
            },
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/robiulaw/public_html/resources/views/admin/banner/form.blade.php ENDPATH**/ ?>