<div class="mi-card">
    <!--start of mi-fc-card-->
    <div class="mi-header <?php echo e($status); ?> ">
        <?php if(isset($data)): ?>
        EDIT BRAND
        <a href="<?php echo e(route('product-brand.create')); ?>">
            <button class="butn butn-sm mi-right success">ADD NEW BRAND</button>
        </a>
        <?php else: ?>
        ADD NEW BRAND
        <?php endif; ?>
    </div>
    <!--end of mi card header-->
    <form action="<?php echo e(route('product-brand.store')); ?>" method="POST" enctype="multipart/form-data">
        <div class="mi-body">
            <!--mi-card body started-->
            <?php echo csrf_field(); ?>
            <?php if(isset($data)): ?>
            <input name="id" type="hidden" value="<?php echo e($data->id); ?>">
            <?php endif; ?>
            <div class="row">
                <div class="form-group col-sm-3">
                    <label for="">COMPANY NAME</label>
                    <select name="company" id="company" class="form-control">
                        <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($company->id); ?>" <?php echo e(isset($data)?($data->company_id == $company->id?'selected':''):''); ?>><?php echo e($company->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="form-group col-sm-4">
                    <label>BRAND NAME (ENGLISH) <b class="text-danger">*</b>
                    </label>
                    <input type="text" placeholder="BRAND NAME ENGLISH" name="brand_name_en" id="brand_name_en" class="form-control"
                        value="<?php echo e(isset($data)?$data->brand_name_en:old('brand_name_en')); ?>" required>
                </div>
                <div class="form-group col-sm-3">
                    <label>BRAND NAME (BANGLA) <b class="text-danger">*</b>
                    </label>
                    <input type="text" placeholder="BRAND NAME Bangla" name="brand_name_bn" id="brand_name_bn" class="form-control"
                        value="<?php echo e(isset($data)?$data->brand_name_bn:old('brand_name_bn')); ?>" required>
                </div>
                <div class="col-sm-2 m-auto">
                    <button type="submit" class="butn <?php echo e($status); ?> w-100 mt-2"> <?php echo e(isset($data)?'UPDATE':'CREATE'); ?> </button>
                </div>
            </div>
        </div>
        <!--end of mi-card-body-->
    </form>
</div>
<!--end of mi-fc-card-->
<?php /**PATH /home/robiulaw/public_html/resources/views/admin/brand/form.blade.php ENDPATH**/ ?>