
<?php $__env->startSection('content'); ?> 
    <style>
        th{
            padding: 7px !important
        }
        th,td{
            font-size: 13px !important;
        }
        .mi-header{
            padding: .5rem 1rem !important
        }
        table{
            margin-bottom: 0px !important;
        }
    </style>
    <div class="row order">
        <div class="col-sm-12">
            <div class="header">
                <div>
                    <p class="order_number text-red d-flex"><?php echo e($order->order_number); ?> <span class="text-gray ps-2" style="font-weight: 400">  - <?php echo e(getPaymentMethod($order->payment_method)); ?></span></p>
                    <p class="text-gray">Order Time : <?php echo e(date('d M Y H:i',strtotime($order->created_at))); ?></p>
                </div>
                <button class="butn butn-sm danger" data-bs-toggle="modal" data-bs-target="#howtoprep">How to prepare order</button>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="order-card">
                <div class="header">
                    <h4>Order Information</h4>
                </div>
                <div class="info-text">
                    <div>
                        <p class="text-red label">Customer Name</p>
                        <p class="text-gray"><?php echo e(optional($order->user)->first_name); ?> <?php echo e(optional($order->user)->last_name); ?></p>
                    </div>
                    <div>
                        <p class="text-red label">Order Number</p>
                        <p class="text-gray"><?php echo e(optional($order)->order_number); ?></p>
                    </div>
                    <div class="phone">
                        <i class="fa fa-phone-alt text-red"></i>
                        <p>To reach the customer , call <?php echo e(optional($order->user)->phone); ?></p>
                    </div>
                    <div>
                        <p class="text-red label">Delivery location</p>
                        <p class="text-gray">Sylhet,Sylhet,Shahporan,Boteshor</p>
                    </div>
                    <div>
                        <p class="text-red label">Payment Status</p>
                        <p class="text-gray">Paid - ৳100 | Due - ৳200</p>
                    </div>
                </div>
            </div>
            <div class="order-card">
                <div class="header">
                    <h4>Delivery Hub Information</h4>
                </div>
                <div class="info-text">
                    <div>
                        <p class="text-red label">Hub Name</p>
                        <p class="text-gray"><?php echo e(optional($order->hub)->business_title); ?></p>
                    </div>
                    <div>
                        <p class="text-red label">Propiter Name</p>
                        <p class="text-gray"><?php echo e(optional($order->hub)->propiter_name); ?></p>
                    </div>
                    <div class="phone">
                        <i class="fa fa-phone-alt text-red"></i>
                        <p>To reach the Propiter , call <?php echo e(optional($order->hub)->phone); ?></p>
                    </div>
                    <div>
                        <p class="text-red label">Hub location</p>
                        <p class="text-gray">Sylhet,Sylhet,Shahporan,Boteshor</p>
                    </div>
                </div>
            </div>

            <div class="order-card" style="padding-top: 45px;">
                <div class="wrapper orderStatus">
                    <?php $statusTime = statusTimes($order->id) ?>
                    <ul class="status-line">
                      <li class="<?php echo e($statusTime->confirmed_time?'active':''); ?>"><i class="<?php echo e($statusTime->confirmed_time?'done':''); ?> flaticon-shopping-bag"></i><p class="text-gray">Order Confirmed</p><p><?php echo e($statusTime->confirmed_time?date('d-m-Y H:i',strtotime($statusTime->confirmed_time)):''); ?></p></li>
                      <li class="<?php echo e($statusTime->accepted_time?'active':''); ?>"><i class="<?php echo e($statusTime->accepted_time?'done':''); ?> flaticon-order"></i><p class="text-gray">Order Accepted</p><p><?php echo e($statusTime->accepted_time?date('d-m-Y H:i',strtotime($statusTime->accepted_time)):''); ?></p></li>
                      <li class="<?php echo e($statusTime->reached_time?'active':''); ?>"><i class="<?php echo e($statusTime->reached_time?'done':''); ?> flaticon-product-1"></i><p class="text-gray">Reached in delivery hub</p><p><?php echo e($statusTime->reached_time?date('d-m-Y H:i',strtotime($statusTime->reached_time)):''); ?></p></li>
                      <li class="<?php echo e($statusTime->ready_for_delivery_time?'active':''); ?>"><i class="<?php echo e($statusTime->ready_for_delivery_time?'done':''); ?> flaticon-booking"></i><p class="text-gray">Ready for delivery</p><p><?php echo e($statusTime->ready_for_delivery_time?date('d-m-Y H:i',strtotime($statusTime->ready_for_delivery_time)):''); ?></p></li>
                      <li class="<?php echo e($statusTime->out_for_delivery_time?'active':''); ?>"><i class="<?php echo e($statusTime->out_for_delivery_time?'done':''); ?> flaticon-fast-delivery"></i><p class="text-gray">Out for delivery</p><p><?php echo e($statusTime->out_for_delivery_time?date('d-m-Y H:i',strtotime($statusTime->out_for_delivery_time)):''); ?></p></li>
                      <li class="<?php echo e($statusTime->delivered_time?'active':''); ?>"><i class="<?php echo e($statusTime->delivered_time?'done':''); ?>  flaticon-delivered-1"></i><p class="text-gray">Delivered</p><p><?php echo e($statusTime->delivered_time?date('d-m-Y H:i',strtotime($statusTime->delivered_time)):''); ?></p></li>
                    </ul>
                  </div>
            </div>
        </div>
        <div class="col-sm-12">
            <div class="mi-card">
                <div class="mi-header text-red">
                    Order Items
                </div>
                <div class="mi-body">
                    <table class="table mi-table table-bordered">
                        <thead>
                            <tr>
                                <th>Image</th>
                                <th>Item Name</th>
                                <th>Shop Name</th>
                                <th>Qty</th>
                                <th>Price</th>
                                <th>Hub</th>
                                <th>Subtotal</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $orderItems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                                <tr>
                                    <td>
                                        <img src="<?php echo e(optional($orderItems->product)->thumbnail_url); ?>" width="60px" alt="">
                                    </td>
                                    <td>
                                        <p><span>En: </span><?php echo e(optional($orderItems->product)->product_name_en); ?></p>
                                        <p><span>En: </span><?php echo e(optional($orderItems->product)->product_name_bn); ?></p>
                                    </td>
                                    <td>
                                        <p><span>En: </span><?php echo e(optional($orderItems->shop)->shop_name_en); ?></p>
                                        <p><span>En: </span><?php echo e(optional($orderItems->shop)->shop_name_bn); ?></p>
                                    </td>
                                    <td class="center">
                                        <?php echo e(optional($orderItems)->qty); ?>

                                    </td>
                                    <td>
                                        <p><span>Price: </span>৳<?php echo e(optional($orderItems)->price); ?></p>
                                        <p><span>Discount: </span>৳<?php echo e(optional($orderItems)->discount); ?></p>
                                    </td>
                                    <td>
                                        <p><span>Hub: </span><?php echo e(optional($orderItems->hub)->hub_name); ?></p>
                                        <p><span>Status: <?php echo e(getOrderItemStatus($orderItems->status)); ?></span></p>
                                    </td>
                                    <td class="center">
                                        ৳<?php echo e(optional($orderItems)->price - optional($orderItems)->discount); ?>

                                    </td>
                                    <?php if($orderItems->status < 2): ?>
                                    <td>
                                        <button type="button" class="butn butn-sm success transparent" data-bs-toggle="modal" data-bs-target="#acceptModal<?php echo e($orderItems->id); ?>"><i class="fa fa-check"></i></button>
                                          <!-- Modal -->
                                        <div class="modal fade" id="acceptModal<?php echo e($orderItems->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-content mi-card">
                                                <div class="mi-header info">RECIVE PRODUCT IN HUB</div>
                                                <form action="<?php echo e(route('order.item-status-change',['order_item_id'=>$orderItems->id])); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="mi-body">
                                                        <div class="form-group">
                                                            <label for="">PLEASE SELECT ONE</label>
                                                            <div class="form-check">
                                                                    <?php if($orderItems->status == 1): ?>
                                                                    <input class="form-check-input" type="radio" name="status" value="2" id="accept<?php echo e($orderItems->id); ?>" checked required>
                                                                    <label class="form-check-label" for="accept<?php echo e($orderItems->id); ?>">
                                                                    ACCEPT (PRODUCT REACHED IN CUSTOMER DELIVERY HUB)
                                                                    </label>
                                                                    <?php elseif($orderItems->status == 0): ?>
                                                                    <input class="form-check-input" type="radio" name="status" value="1" id="accept<?php echo e($orderItems->id); ?>" checked required>
                                                                    <label class="form-check-label" for="accept<?php echo e($orderItems->id); ?>">
                                                                    ACCEPT (PRODUCT REACHED AT SELLER NEAREST DELIVERY HUB)
                                                                    </label>
                                                                <?php endif; ?>
                                                              </div>

                                                              <div class="form-check">
                                                                <input class="form-check-input" type="radio" name="status" value="3" id="reject<?php echo e($orderItems->id); ?>2" required>
                                                                <label class="form-check-label" for="reject<?php echo e($orderItems->id); ?>2">
                                                                  REJECT (FOR SOME RESON PRODUCT CANT BE DELIVERED)
                                                                </label>
                                                            </div>
                                                        </div>

                                                        <div class="form-group">
                                                            <label for="">WRITE A NOTE <b class="text-danger">*</b></label>
                                                            <textarea name="note" id="note" class="form-control" rows="3" required></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="mi-footer text-center">
                                                        <button class="butn success">SAVE</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                        <tfoot>
                            <?php $itemsTotal = getItemsTotal($order->orderItems) ?>
                            <tr>
                                <th colspan="6">Items Total</th>
                                <td>৳ <?= $itemsTotal ?></td>
                            </tr>
                            <tr>
                                <th colspan="6">Tax</th>
                                <td>৳ <?php echo e($order->tax); ?></td>
                            </tr>
                            <tr>
                                <th colspan="6">Delivery Charge</th>
                                <td>৳ <?php echo e($order->delivery_charge); ?></td>
                            </tr>
                            <tr>
                                <th colspan="6">Discount</th>
                                <td>- ৳ <?php echo e($order->discount_amount); ?></td>
                            </tr>
                            <tr>
                                <th colspan="6">Total</td>
                                <td>৳ <?php echo e(($itemsTotal+$order->tax+$order->delivery_charg)-$order->discount_amount); ?></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mi-card">
                <div class="mi-header text-red">Order Status History</div>
               <div class="mi-body">
                    <?php $__currentLoopData = $order->orderStatusHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="status-card">
                        <div style="width: 120px">
                            <p class="text-red"><?php echo e(getStatus($history->status_id)); ?></p>
                        </div>
                        <div>
                            <p><span class="label">Date:</span> <?php echo e(date('d M Y H:i:A',strtotime($history->created_at))); ?></p>
                            <p><span class="label">Note:</span> <?php echo e($history->note); ?></p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </div>
            </div>
        </div>
        <div class="col-sm-6">
            <div class="mi-card">
                <div class="mi-header text-red">Order Item History</div>
               <div class="mi-body">
                    <?php $__currentLoopData = $order->orderItemHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $itemHistory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="status-card">
                        <div>
                            <p><span class="label">Date:</span> <?php echo e(date('d M Y H:i',strtotime($itemHistory->created_at))); ?></p>
                            <p class="text-red"> <?php echo e(getOrderItemStatus($itemHistory->status)); ?></p>
                        </div>
                        <div>
                            <p>Product name : <?php echo e(optional($itemHistory->item)->product_name_en); ?></p>
                            <p><span class="label">Note:</span> Order placed by user</p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
               </div>
            </div>
        </div>
        <div class="col-sm-12 floa-right">
            <div class="buttons">
                <?php if($order->status < ORDER_DELIVERED): ?>
                <a ><button class="butn danger">CANCEL</button></a>
                <?php endif; ?>
                <?php if($order->status == ORDER_PENDING): ?>
                <a onclick="return confirmBox({'status':'success','title':'Are you sure to accept this order ? ','body':'If you accept this order than this order will go to the seller panel & delivery hub'},event)" href="<?php echo e(route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_ACCEPTED])); ?>" ><button class="butn success"  >ACCEPT ORDER</button></a>
                <?php elseif($order->status == ORDER_ACCEPTED): ?>
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Are you sure that all items reached in delivery hub please verify'},event)" href="<?php echo e(route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_REACHED_IN_DELIVERY_HUB])); ?>" ><button class="butn warning"  >ITEMS REACHED IN DELIVERY HUB</button></a>
                <?php elseif($order->status == ORDER_REACHED_IN_DELIVERY_HUB): ?>
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Are you sure order is ready for delivery'},event)" href="<?php echo e(route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_READY_FOR_DELIVERY])); ?>" ><button class="butn info"  >ORDER IS READY FOR DELIVERY</button></a>
                <?php elseif($order->status == ORDER_READY_FOR_DELIVERY): ?>
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Please verify that order is out for delivery or not'},event)" href="<?php echo e(route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_OUT_FOR_DELIVERY])); ?>" ><button class="butn warning"  >ORDER IS OUT FOR DELIVERY</button></a>
                <?php elseif($order->status == ORDER_OUT_FOR_DELIVERY): ?>
                <a onclick="return confirmBox({'status':'success','title':'Are you sure ? ','body':'Please be sure order is deliverd or not'},event)" href="<?php echo e(route('order.status.change',['order_id'=>$order->id,'status'=>ORDER_DELIVERED])); ?>" ><button class="butn success"  >ORDER DELIVERED</button></a>
                <?php endif; ?>

            </div>
        </div>
    </div>


    <!-- Modal -->
<div class="modal fade" id="howtoprep" tabindex="-1" aria-labelledby="howtoprepLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content mi-card">
        <div class="mi-header info">
          <h5 class="modal-title" id="howtoprepLabel">How To Prepare Order</h5>
        </div>
        <div class="mi-body">
          <img src="https://partner.movo.delivery/assets/order-prep-tips.webp" width="100%" alt="">
        </div>
        <div class="mi-footer text-center">
          <button type="button" class="butn danger" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
  
  
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\ezone\e-zone\resources\views/admin/order/view.blade.php ENDPATH**/ ?>