<?php $__env->startSection('content'); ?>
<style>
    p{
        margin-bottom: 1px;
        font-family: 'Rubik';
        font-weight: 400;
    }
    span{
        color: #ccc;
    }
</style>
<div class="mi-card">
    <div class="mi-header info">
        PRODUCTS LIST
        <a href="<?php echo e(route('product-basic-info.create')); ?>">
            <button class="butn success mi-right">ADD NEW PRODUCT INFO</button>
        </a>
    </div>
    <div class="mi-body">
        <div class="filter mb-3">
            <form method="get">
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="Filter by company">FILTER BY COMPANY</label>
                        <select name="company_id" id="company_id" class="form-control">
                            <option value="">Select one</option>
                            <?php $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($company->id); ?>" <?php echo e($company->id==request('company_id')?'selected':''); ?>><?php echo e($company->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILER BY CATEGORY</label>
                        <select name="category_id" id="category_id" class="form-control">
                            <option value="">Select one</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>" <?php echo e($category->id==request('category_id')?'selected':''); ?>><?php echo e($category->category_name_en); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY SUBCATEGORY</label>
                        <select name="subcategory_id" id="subcategory_id" class="form-control">
                            <option value="">Select one</option>
                            <?php $__currentLoopData = $subcategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subcategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($subcategory->id); ?>" <?php echo e($subcategory->id==request('subcategory_id')?'selected':''); ?>><?php echo e($subcategory->subcategory_name_en); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY BRAND</label>
                        <select name="brand_id" id="brand_id" class="form-control">
                            <option value="">Select one</option>
                            <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($brand->id); ?>" <?php echo e($brand->id==request('brand_id')?'selected':''); ?>><?php echo e($brand->brand_name_en); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">FILTER BY STATUS</label>
                        <select name="status" id="status" class="form-control">
                            <option value="">Select one</option>
                            <option value="1" <?php echo e(request('status') == 1?'selected':''); ?>>Active</option>
                            <option value="0" <?php echo e(request('status') == 0?'selected':''); ?>>Deactive</option>
                        </select>
                    </div>
                    <div class="form-group col-sm-3 pt-4">
                        <button type="submit" class="butn warning">Filter</button>
                        <a href="<?php echo e(route('product-basic-info.list')); ?>"><button type="button" class="butn danger">Clear</button></a>
                    </div>
                </div>
            </form>
        </div>
        <table class="table mi-table table-bordered" id="dataTable">
            <thead>
                <tr>
                    <th>Thumbnail</th>
                    <th>Product Name</th>
                    <th>Category</th>
                    <th>Subcategory</th>
                    <th>Brand</th>
                    <th>Company Name</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><img src="<?php echo e($product->thumbnail_url); ?>" width="70px" alt=""></td>
                    <td>
                        <p><span>En:</span><?php echo e($product->product_name_en); ?></p>
                        <p><span>Bn:</span><?php echo e($product->product_name_bn); ?></p>
                    </td>
                    <td>
                        <p><span>En:</span><?php echo e(optional($product->category)->category_name_en); ?></p>
                        <p><span>Bn:</span><?php echo e(optional($product->category)->category_name_bn); ?></p>
                    </td>
                    <td>
                        <p><span>En:</span><?php echo e(optional($product->subcategory)->subcategory_name_en); ?></p>
                        <p><span>Bn:</span><?php echo e(optional($product->subcategory)->subcategory_name_bn); ?></p>
                    </td>
                    <td>
                        <p><span>En:</span><?php echo e(optional($product->brand)->brand_name_en); ?></p>
                        <p><span>Bn:</span><?php echo e(optional($product->brand)->brand_name_bn); ?></p>
                    </td>
                    <td>
                        <?php echo e(optional($product->company)->name); ?>

                    </td>
                    <td class="mi-action-button">
                        <a href="<?php echo e(route('product-basic-info.edit',['id'=>$product->id])); ?>">
                          <button class="butn warning transparent">
                            <i class="fa fa-edit"></i>
                          </button>
                        </a>
                        <a onclick="return confirm('Are you sure to delete')" href="<?php echo e(route('product-basic-info.delete',['id'=>$product->id])); ?>">
                          <button class="butn danger transparent">
                            <i class="fa fa-trash"></i>
                          </button>
                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/robiulaw/public_html/resources/views/admin/product-basic-info/list.blade.php ENDPATH**/ ?>