<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header info">LIST OF RETURNED ITEMS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Customer</th>
                    <th>Shop</th>
                    <th>Product</th>
                    <th>Date</th>
                    <th>#</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($item->id); ?></td>
                    <td>
                        <p style="white-space: nowrap"><span>Name : </span><?php echo e($item?->user?->first_name. ' ' . $item?->user?->last_name); ?></p>
                        <p style="white-space: nowrap"><span>Phone : </span> <?php echo e($item?->user?->phone); ?></p>
                    </td>
                    <td>
                        <p style="white-space: nowrap"><span>Name : </span><?php echo e($item?->orderItem?->shop?->name); ?></p>
                        <p style="white-space: nowrap"><span>Phone : </span> <?php echo e($item?->orderItem->shop?->phone); ?></p>
                    </td>
                    <td>
                        <p><a target="_blank" href="<?php echo e(route('product.edit',['id'=>$item?->orderItem?->product?->id])); ?>"><span>Name : </span><?php echo e(strLimit($item?->orderItem?->product?->name , 40)); ?></a></p>
                        <p>
                            <?php if($item?->orderItem?->size): ?>
                            <span>Size : </span> <?php echo e($item?->orderItem?->size); ?>

                            <?php endif; ?>
                            <?php if($item?->orderItem?->color): ?>
                            <span class="ps-2">Color : </span> <span style="background-color:<?php echo e($item?->orderItem?->color); ?>;padding:1px 15px;margin-left:5px"></span>
                            <?php endif; ?>
                        </p>
                    </td>
                    <td>
                        <?php echo e(date('Y-m-d H:i:s',strtotime($item?->created_at))); ?></p>
                        <p style="white-space: nowrap"><span>Status : </span><?php echo e($item?->status_text); ?></p>
                    </td>
                    <td class="mi-action-button">
                       <a href="<?php echo e(route('return.view',['id'=>$item->id])); ?>" >
                            <button class="butn info transparent" type="button"><i class="fa fa-eye"></i></button>
                        </a>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/robiulaw/public_html/resources/views/admin/return/list.blade.php ENDPATH**/ ?>