<?php $__env->startSection('content'); ?>
<style>
  p{
      margin-bottom: 1px;
      font-family: 'Rubik';
      font-weight: 400;
  }
  span{
      color: #ccc;
  }
</style>
<form action="<?php echo e(route('offer.store')); ?>" method="POST" enctype="multipart/form-data">
<div class="mi-card">
    <!--start of mi-fc-card-->
    <div class="mi-header <?php echo e($status); ?> ">
      <!--mi card header started--><?php echo e($title); ?> OFFERS
    </div>
    <!--end of mi card header-->
      <div class="mi-body">
        <!--mi-card body started-->
        <input name="_token" type="hidden" value="<?php echo e(csrf_token()); ?>"> <?php if(isset($data)): ?> <input name="id" type="hidden" value="<?php echo e($data->id); ?>"> <?php endif; ?> <div class="row">
          <div class="form-group col-sm-6">
            <label>OFFER NAME (ENGLISH) <b class="text-danger">*</b>
            </label>
            <input type="text" placeholder="OFFER NAME (ENGLISH)" name="offer_name_en" id="offer_name_en" class="form-control" value="<?php echo e(isset($data)?$data->offer_name_en:old('offer_name_en')); ?>" required>
          </div>
          <div class="form-group col-sm-6">
            <label>OFFER NAME (BANGLA) <b class="text-danger">*</b>
            </label>
            <input type="text" placeholder="OFFER NAME (BANGLA)" name="offer_name_bn" id="offer_name_bn" class="form-control" value="<?php echo e(isset($data)?$data->offer_name_bn:old('offer_name_bn')); ?>" required>
          </div>
          <div class="form-group col-sm-6">
            <label>START DATE <b class="text-danger">*</b>
            </label>
            <input type="date" placeholder="START DATE" name="start_date" id="start_date" class="form-control" value="<?php echo e(isset($data)?$data->start_date:old('start_date')); ?>" required>
          </div>
          <div class="form-group col-sm-6">
            <label>END DATE <b class="text-danger">*</b>
            </label>
            <input type="date" placeholder="END DATE" name="end_date" id="end_date" class="form-control" value="<?php echo e(isset($data)?$data->end_date:old('end_date')); ?>" required>
          </div>
          <div class="col-sm-6">
            <div class="form-group">
              <label>AMOUNT TYPE <b class="text-danger">*</b></label>
              <select name="amount_type" id="amount_type">
                  <option value="">Select One</option>
                  <option value="F" <?php echo e(isset($data) ? (optional($data)->amount_type == 'F'?'selected':'') : ''); ?>>Flat</option>
                  <option value="P" <?php echo e(isset($data) ? (optional($data)->amount_type == 'P'?'selected':'') : ''); ?>>Percentage</option>
              </select>
            </div>
            <div class="form-group">
              <label>AMOUNT <b class="text-danger">*</b>
              </label>
              <input type="text" placeholder="AMOUNT" name="amount" id="amount" class="form-control" value="<?php echo e(isset($data)?$data->amount:old('amount')); ?>" required>
            </div>
          </div>
          <div class="form-group position-relative col-sm-6">
            <label>OFFER BANNER IMAGE <b class="text-danger">*</b>
            </label> <?php if(isset($data)): ?> <div class="edit-image">
              <a href="<?php echo e($data->image_url); ?>">
                <img src="<?php echo e($data->image_url); ?>" alt="">
              </a>
            </div> <?php endif; ?> <input type="file" name="image" id="image" class="form-control <?php echo e(isset($data)?'edit-input':''); ?> ">
        </div>
        </div>
      </div>

  </div>
  <div class="mi-card">
    <div class="mi-header info">SELECT OFFER PRODUCTS</div>
    <div class="mi-body">
      <table class="mi-table table table-bordered table-striped" id="dataTable">
        <thead>
          <tr>
            <th>ID</th>
            <th>IMAGE</th>
            <th>PRODUCT NAME</th>
            <th>CAT & SUBCAT</th>
            <th>SHOP & BRAND</th>
            <th>PRICE</th>
          </tr>
        </thead>
        <tbody> <?php $i=0; ?> <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <tr>
            <td><input class="form-check-input" name="product_ids[]" value="<?php echo e($product->id); ?>" type="checkbox" <?php if(isset($offeredProducts)){ echo in_array($product->id,$offeredProducts)?'checked':''; } ?> id="flexCheckDefault"></td>
            <td><img width="70px" src="<?php echo e(optional($product)->thumbnail_url); ?>" alt=""></td>
            <td>
              <p><span>En:</span><?php echo e(optional($product)->product_name_en); ?></p>
              <p><span>Bn:</span><?php echo e(optional($product)->product_name_bn); ?></p>
            </td>
            <td>
              <p><span>Cat:</span><?php echo e(optional($product->category)->category_name_en); ?></p>
              <p><span>Subcat:</span><?php echo e(optional($product->subcategory)->subcategory_name_en); ?></p>
            </td>
            <td>
              <p><span>Shop:</span><?php echo e(optional($product->shop)->shop_name_en); ?></p>
              <p><span>Brand:</span><?php echo e(optional($product->brand)->brand_name_en); ?></p>
            </td>
            <td>
              <p><span>P Price:</span><?php echo e(optional($product)->original_price); ?></p>
              <p><span>S Price:</span><?php echo e(optional($product)->sale_price); ?></p>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
    <div class="mi-footer">
      <!--mi-card footer started-->
      <div class="row">
        <div class="col-sm-4 m-auto">
          <button type="submit" class="butn <?php echo e($status); ?> w-100"> <?php echo e($button_name); ?> </button>
        </div>
      </div>
    </div>
  </div>
</form>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/robiulaw/public_html/resources/views/admin/offer/form.blade.php ENDPATH**/ ?>