<?php $__env->startSection('content'); ?>
    <?php
        $totalOrders = 0;
        $totalDelivered = 0;
        $totalCancelled = 0;
        $totalOnProcess = 0;
        $deliverdTotal = 0;
    ?>
    <div class="mi-card">
        <div class="mi-header info">
            SALES REPORT
        </div>
        <div class="mi-body">
            <form action="" method="get">
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="">Start Date</label>
                        <input type="date" class="form-control" name="start_date" value="<?php echo e(request('start_date')); ?>">
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">End Date</label>
                        <input type="date" class="form-control" name="end_date" value="<?php echo e(request('end_date')); ?>">
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">Customer</label>
                        <select name="user_id" id="user_id" class="form-control">
                            <option value="">Select a customer</option>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($customer->id); ?>"  <?php echo e(request('user_id')==$customer->id?'selected':''); ?>><?php echo e($customer->first_name); ?>  <?php echo e($customer->last_name); ?> - <?php echo e($customer->phone); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">Shops</label>
                        <select name="shop_id" id="shop_id" class="form-control" >
                            <option value="">Select a shop</option>
                            <?php $__currentLoopData = $shops; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shop): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php echo e(request('shop_id')==$shop->id?'selected':''); ?> value="<?php echo e($shop->id); ?>"><?php echo e($shop->shop_name_en); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                </div>
                <div class="d-flex" style="justify-content: flex-end;gap:10px">
                    <a href="<?php echo e(route('report.customer.sales-report')); ?>"><button class="butn butn-sm danger">Clear</button></a>
                    <button class="butn butn-sm success">Filter</button>
                </div>
            </form>


            <?php if($data): ?>
            <div class="mt-3">
                <table class="table mi-table table-bordered " id="dataTable">
                    <thead>
                        <th>Date</th>
                        <th>Deivered Order</th>
                        <th>Inprogress Order</th>
                        <th>Cancelled Order</th>
                        <th>Cancelled Total</th>
                        <th>Delivered Total</th>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $totalOrders += (int)$item->total_orders;
                            $totalDelivered += (int)$item->delivered_orders;
                            $totalCancelled += (int)$item->cancelled_orders;
                            $totalOnProcess += (int)$item->other_orders;
                            $deliverdTotal += (float)$item->delivered_orders_total
                        ?>
                        <tr>
                            <td><?php echo e($item->date); ?></td>
                            <td><?php echo e($item->delivered_orders); ?></td>
                            <td><?php echo e($item->other_orders); ?></td>
                            <td><?php echo e($item->cancelled_orders); ?></td>
                            <td><?php echo e($item->cancelled_orders_total); ?></td>
                            <td><?php echo e($item->delivered_orders_total); ?></td>

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

                <div class="mi-box mt-5">
                    <div class="referrels gray-box">
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Total Orders</p>
                                <h6><?php echo e($totalOrders); ?></h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Delivered Orders</p>
                                <h6><?php echo e($totalDelivered); ?></h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Cancelled Orders</p>
                                <h6><?php echo e($totalCancelled); ?></h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>On Process</p>
                                <h6><?php echo e($totalOnProcess); ?></h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Delivered Total</p>
                                <h6><?php echo e($deliverdTotal); ?></h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/robiulaw/public_html/resources/views/admin/reports/customer-sales-report.blade.php ENDPATH**/ ?>