<?php $__env->startSection('content'); ?>
<div class="row order">
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header text-red">RETURN REQUEST INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Request Date</th>
                        <td><?php echo e(date('d M Y H:i a', strtotime($details->created_at))); ?></td>
                    </tr>
                    <tr>
                        <th>Order Number</th>
                        <td><a href="<?php echo e(route('order.view',['id'=>$details?->orderItem?->order_id])); ?>"><?php echo e($details?->orderItem?->order?->order_number); ?></a></td>
                    </tr>
                    <tr>
                        <th>Client Name</th>
                        <td><?php echo e($details?->user?->name); ?></td>
                    </tr>
                    <tr>
                        <th>Client Phone</th>
                        <td><?php echo e($details?->user?->phone); ?></td>
                    </tr>
                    <tr>
                        <th>Address</th>
                        <td><?php echo e($details?->user?->address); ?></td>
                    </tr>
                    <tr>
                        <th>Client Note</th>
                        <td class="text-danger"><?php echo e($details?->note); ?></td>
                    </tr>
                    <tr>
                        <th>Status</th>
                        <td class="text-text-red"><?php echo e($details?->status_text); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="mi-card">
            <div class="mi-header text-red">SHOP INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Shop name</th>
                        <td><?php echo e($details?->orderItem?->shop?->name); ?></td>
                    </tr>
                    <tr>
                        <th>Shop phone</th>
                        <td><?php echo e($details?->orderItem?->shop?->phone); ?></td>
                    </tr>
                    <tr>
                        <th>Shop Address</th>
                        <td><?php echo e($details?->orderItem?->shop?->shop_address); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        <div class="mi-card">
            <div class="mi-header text-red">SELLER INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Seller name</th>
                        <td><?php echo e($details?->orderItem?->shop?->user?->name); ?></td>
                    </tr>
                    <tr>
                        <th>Seller phone</th>
                        <td><?php echo e($details?->orderItem?->shop?->user?->phone); ?></td>
                    </tr>
                    <tr>
                        <th>Seller Address</th>
                        <td><?php echo e($details?->orderItem?->shop?->user?->address); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header text-red">PRODUCT INFORMATION</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Product Image</th>
                        <td>
                            <img src="<?php echo e($details?->orderItem?->product?->thumbnailImage?->file_url); ?>" alt="image not found">
                        </td>
                    </tr>
                    <tr>
                        <th>Product name</th>
                        <td><?php echo e($details?->orderItem?->product?->name); ?></td>
                    </tr>
                    <tr>
                        <th>Product Size</th>
                        <td><?php echo e($details?->orderItem?->size); ?></td>
                    </tr>
                    <tr>
                        <th>Product Color</th>
                        <td><p class="mb-0" style="background: <?php echo e($details?->orderItem?->color); ?>;padding:15px 10px"></p></td>
                    </tr>
                    <tr>
                        <th>Item Sold Price</th>
                        <td><?php echo e($details?->orderItem?->price); ?></td>
                    </tr>
                    <tr>
                        <th>Total Quantity</th>
                        <td><?php echo e($details?->orderItem?->qty); ?></td>
                    </tr>

                    <tr>
                        <th>Total</th>
                        <td><?php echo e($details?->orderItem?->qty*$details?->orderItem?->price); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        <?php if($details->status == RETURN_REQUEST_PENDING || $details->status == RETURN_REQUEST_ACCEPTED): ?>
        <form action="<?php echo e(route('return.change-status')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="modal-content mi-card">
                <div class="mi-header warning transparent">
                    ACCEPT / REJECT RETURN REQUEST
                </div>
                <div class="mi-body">
                    <input type="hidden" name="id" value="<?php echo e($details->id); ?>">
                    <div class="form-group">
                        <label for="">Status</label>
                        <select name="status" id="status" class="form-control" required>
                            <option value="">Select Status</option>
                            <option value="<?php echo e(RETURN_REQUEST_ACCEPTED); ?>" <?php echo e($details->status == RETURN_REQUEST_ACCEPTED?'selected':''); ?>>ACCEPT RETURN REQUEST</option>
                            <option value="<?php echo e(RETURN_REQUEST_REJECTED); ?>" <?php echo e($details->status == RETURN_REQUEST_REJECTED?'selected':''); ?>>REJECT RETURN REQUEST</option>
                            <option value="<?php echo e(REFUNDED_BY_SELLER); ?>" <?php echo e($details->status == REFUNDED_BY_SELLER?'selected':''); ?>>REFUNDED</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Admin Note (It will be visible to the customer)</label>
                        <textarea name="admin_note" id="admin_note" class="form-control" rows="5" placeholder="Please Write A Note (It will be visible to the customer)" required><?php echo e($details->admin_note); ?></textarea>
                    </div>
                </div>
                <div class="mi-footer text-center">
                    <button type="submit" class="butn warning">Submit</button>
                </div>
            </div>
        </form>
        <?php else: ?>
         <div class="mi-card">
            <div class="mi-header text-red">NOTES</div>
            <div class="mi-body">
                <table  class="table table-bordered table-striped">
                    <tr>
                        <th>Client Note</th>
                        <td><?php echo e($details->note); ?></td>
                    </tr>
                    <tr>
                        <th>Admin Note</th>
                        <td><?php echo e($details->admin_note); ?></td>
                    </tr>

                </table>
            </div>
        </div>
        <?php endif; ?>
    </div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/robiulaw/public_html/resources/views/admin/return/view.blade.php ENDPATH**/ ?>