<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header info">
        All Packages
        <a href="<?php echo e(route('admin.mystore.package.create')); ?>">
            <button class="butn success mi-right">Add Package</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Package Name</th>
                    <th>Price</th>
                    <th>TSC</th>
                    <th>Daily Income Limit</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($package->id); ?></td>
                        <td><?php echo e($package->name); ?></td>
                        <td><?php echo e(numberformat($package->price)); ?></td>
                        <td><?php echo e($package->tsc); ?>%</td>
                        <td><?php echo e(numberformat($package->daily_income)); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.mystore.package.edit', ['id' => $package->id])); ?>">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('<?php echo e(route('admin.mystore.package.delete', ['id' => $package->id])); ?>','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/admin/my-store/package/index.blade.php ENDPATH**/ ?>