<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header info">
        All Contacts
        <a href="<?php echo e(route('admin.contact.create')); ?>">
            <button class="butn success mi-right">Add Contact</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Icon</th>
                    <th>Title</th>
                    <th>Value</th>
                    <th>Link</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($contact->id); ?></td>
                        <td><img src="<?php echo e($contact->icon_url); ?>" width="35px" alt=""></td>
                        <td><?php echo e($contact->title); ?></td>
                        <td><?php echo e($contact->value); ?></td>
                        <td><?php echo e($contact->link); ?></td>
                        <td>
                            <a href="<?php echo e(route('admin.contact.edit', ['id' => $contact->id])); ?>">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('<?php echo e(route('admin.contact.delete', ['id' => $contact->id])); ?>','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/admin/contact/index.blade.php ENDPATH**/ ?>