
<?php $__env->startSection('content'); ?>
    
    <form action="<?php echo e(route('product-basic-info.store')); ?>" method="POST" enctype="multipart/form-data">
        <?php if($data): ?>
        <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <div class="row">
            <div class="col-sm-6" id="app">
                <div class="mi-card">
                    <div class="mi-header success">
                        <?php echo e(optional($data)?'ADD':'EDIT'); ?> PRODUCT INFO
                    </div>
                    <div class="mi-body">
                            <div class="form-group ">
                                <label>SELECT CATEGORY <b class="text-danger">*</b></label>
                                <select class="form-control" id="category_id"  name="category_id"  required>
                                <option selected>SELECT ONE </option> 
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                <option value="<?php echo e($option->id); ?>" <?php echo e(optional($data)->category_id == $option->id?'selected':''); ?>>
                                    <?php echo e($option->category_name_en); ?>

                                </option> 
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group ">
                                <label>SELECT SUBCATEGORY <b class="text-danger">*</b></label>
                                <select class="form-control" id="subcategory_id" name="subcategory_id" required>
                                    <option selected>SELECT ONE </option> 
                                    <option v-for="subcategory in subcategories" :selected="subcategory.id == subcategory_id" :value="subcategory.id">
                                    {{ subcategory.subcategory_name_en }}
                                    </option> 
                                </select>
                            </div>
            
                            <div class="form-group ">
                                <label>SELECT BRAND <b class="text-danger">*</b></label>
                                <select class="form-control" id="brand_id" name="brand_id" required>
                                    <option selected>SELECT ONE </option>
                                    <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($brand->id); ?>" <?php echo e(optional($data)->brand_id == $brand->id?'selected':''); ?>><?php echo e($brand->brand_name_en); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
    
                            <div class=" form-group">
                                <label for="">PRODUCT NAME (ENGLISH)</label>
                                <input type="text" placeholder="Product name - english" name="product_name_en" class="form-control" value="<?php echo e(optional($data)->product_name_en); ?>">
                            </div>
            
                            <div class=" form-group">
                                <label for="">PRODUCT NAME (BANGLA)</label>
                                <input type="text" placeholder="Product name - bangla" name="product_name_bn" class="form-control" value="<?php echo e(optional($data)->product_name_bn); ?>">
                            </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-6" id="app">
                <div class="mi-card">
                    <div class="mi-header success">
                        <?php echo e(optional($data)?'ADD':'EDIT'); ?> PRODUCT IMAGE
                    </div>
                    <div class="mi-body">
                        <div class="form-group position-relative">
                            <label>PRODUCT THUMBNAIL <b class="text-danger">*</b>
                            </label> <?php if(optional($data)->thumbnail): ?> <div class="edit-image">
                              <a href="<?php echo e($data->thumbnail_url); ?>">
                                <img src="<?php echo e($data->thumbnail_url); ?>" alt="">
                              </a>
                            </div> <?php endif; ?> <input type="file" name="thumbnail" id="thumbnail" class="form-control <?php echo e(optional($data)->thumbnail?'edit-input':''); ?> ">
                        </div>
                        <div class="form-group position-relative">
                            <label>PRODUCT IMAGES <b class="text-danger"> (You can upload multiple image)</b></label>
                            <input type="file" multiple name="images[]" id="images" class="form-control">
                        </div>
                        <?php if(optional($data)->images): ?>
                        <div class="d-flex flex-wrap gap-2">
                            <?php $__currentLoopData = optional($data)->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="width: 150px;border-radius: 10px;overflow: hidden;position:relative">
                                <img width="100%" src="<?php echo e($image->file_url); ?>" alt="">
                                <a onclick="return confirm('Are you sure to delete ?')"  href="<?php echo e(route('product-basic-info.delete-image',['id'=>$image->id])); ?>">
                                    <button type="button" class="butn butn-sm danger" style="position: absolute;top: 0;right: 0;"><i class="fa fa-trash"></i></button>
                                </a>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="mi-footer text-center">
                        <button type="submit" class="butn success">SAVE DATA</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
        

    
    <script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.6.3/axios.min.js" integrity="sha512-JWQFV6OCC2o2x8x46YrEeFEQtzoNV++r9im8O8stv91YwHNykzIS2TbvAlFdeH0GVlpnyd79W0ZGmffcRi++Bw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                subcategories:[],
                category_id : <?php echo json_encode(optional($data)->category_id, 15, 512) ?>,
                subcategory_id : <?php echo json_encode(optional($data)->subcategory_id, 15, 512) ?>
            },
            mounted(){
                // this.loadSubcategory(1);
                if(this.category_id){
                    this.loadSubcategory(this.category_id)
                }
                $('#category_id').on('change', this.loadSubcategory);
            },
            methods:{
                loadSubcategory(){
                    const category_id = $('#category_id').val();
                    var subcategory_url = <?php echo json_encode(url('/api/subcategories'), 15, 512) ?>+'/'+category_id 
                    console.log(subcategory_url);
                    axios.get(subcategory_url).then((res)=>{
                        console.log(res.data);
                        this.subcategories = res.data.data;
                    },(error)=>{
                        console.log(error);
                    })
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\ezone\e-zone\resources\views/admin/product-basic-info/form.blade.php ENDPATH**/ ?>