<?php $__env->startSection('content'); ?>
<div class="mi-card">
    <div class="mi-header info">ALL FUND REQUESTS</div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($request->id); ?></td>
                        <td><?php echo e($request->hub?->name); ?></td>
                        <td><?php echo e($request->hub?->email); ?></td>
                        <td><?php echo e($request->hub?->phone); ?></td>
                        <td>৳ <?php echo e(number_format($request->amount, 2)); ?></td>
                        <td><?php echo e($request->status_text); ?></td>
                        <td>
                            <a data-bs-toggle="modal" data-bs-target="#detailsModal">
                                <button class="butn butn-sm info transparent"><i class="fa fa-eye"></i></button>
                            </a>
                            <?php echo $__env->make('admin.my-store.fund.details-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <?php if($request->status == FUND_REQUEST_PENDING): ?>
                                <a
                                    onclick="_confirm('<?php echo e(route('admin.mystore.fund.accept-request', ['id' => $request->id])); ?>','Are you sure to accept this request')">
                                    <button class="butn butn-sm success transparent"><i class="fa fa-check"></i></button>
                                </a>
                                <a onclick="rejectRequest(<?php echo e($request->id); ?>)">
                                    <button class="butn butn-sm danger transparent"><i class="fa fa-times"></i></button>
                                </a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php echo $__env->make('admin.my-store.fund.reject-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
<script>
    function rejectRequest(id){
        $('#request_id').val(id);
        $('#rejectModal').modal('show');
    }
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/admin/my-store/fund/request.blade.php ENDPATH**/ ?>