<div>
    <div class="mi-body">
        <div class="form-group">
            <label for="">Division</label>
            <select name="division_id" id="division_id" class="form-control" wire:model="division_id">
                <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($division->id); ?>"><?php echo e($division->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label for="">District</label>
            <select name="district_id" id="district_id" class="form-control" wire:model="district_id">
                <option value="">Select District</option>
                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($district->id); ?>"><?php echo e($district->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label for="">Upazila</label>
            <select name="upazila_id" id="upazila_id" class="form-control" wire:model="upazila_id">
                <option value="">Select Upazila</option>
                <?php $__currentLoopData = $upazilas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($district->id); ?>"><?php echo e($district->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label for="">Area Name</label>
            <input type="text" name="area_name" id="area_name" wire:model="area_name" class="form-control">
        </div>
    </div>
</div>


<script>
    document.addEventListener('livewire:load', function () {
        // Initialize Select2 on page load
        initializeSelect2();

        Livewire.hook('message.processed', (message, component) => {
            // Reinitialize Select2 after Livewire DOM updates
            initializeSelect2();
        });

        function initializeSelect2() {
            $('#division_id').select2();
            $('#district_id').select2();
            $('#upazila_id').select2();

            // Dispatch change events to Livewire
            $('#division_id').on('change', function (e) {
                const selectedValue = $(this).val();
                Livewire.emit('divisionUpdated', selectedValue); // Trigger Livewire method
            });

            $('#district_id').on('change', function (e) {
                const selectedValue = $(this).val();
                Livewire.emit('districtUpdated', selectedValue);
            });

            $('#upazila_id').on('change', function (e) {
                const selectedValue = $(this).val();
                Livewire.emit('upazilaUpdated', selectedValue);
            });
        }
    });

</script>
<?php /**PATH /home/asn/Projects/EZONE/e-zone/resources/views/livewire/location.blade.php ENDPATH**/ ?>