 
<?php $__env->startSection('content'); ?>

<form action="<?php echo e(route('delivery-hub.store')); ?>" method="post" enctype="multipart/form-data">
  <?php echo csrf_field(); ?>
  <?php if($data): ?>
  <input type="hidden" name="id" value="<?php echo e($data->id); ?>">
  <?php endif; ?>
  <div class="row" id="app">
    <div class="col-sm-6">
      <div class="mi-card">
        <div class="mi-header <?php echo e($data?'warning':'success'); ?>">
          PERSONAL INFORMATION
        </div>
        <div class="mi-body">
          <div class="form-group position-relative">
            <label>PROFILE IMAGE <b class="text-danger">*</b></label>
            <?php if($data): ?> 
            <div class="edit-image">
              <a href="<?php echo e(asset('images'.$data->profile_photo)); ?>">
                <img src="<?php echo e(asset('images'.$data->profile_photo)); ?>" alt="">
              </a>
            </div> 
            <?php endif; ?> 
            <input type="file" name="profile_photo" id="profile_photo" class="form-control <?php echo e($image_class); ?> ">
          </div>
          <div class="form-group">
            <label for="">Name <b class="text-danger">*</b></label>
            <input type="text" name="name" value="<?php echo e(optional($data)->name); ?>" id="name" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Division <b class="text-danger">*</b></label>
            <select name="division" id="division" class="form-control">
              <option value="">Select One</option>
              <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($division->id); ?>" <?php echo e($division->id==optional($data)->division?'selected':''); ?>><?php echo e($division->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="form-group">
            <label for="">District <b class="text-danger">*</b></label>
            <select name="district" id="district" class="form-control">
              <option value="">Select One</option>
              <option :value="district.id" :selected="district.id==district_id" v-for="district in districts">{{district.name}}</option>
            </select>
          </div>
          <div class="form-group">
            <label for="">Police Station <b class="text-danger">*</b></label>
            <input type="text" name="police_station" value="<?php echo e(optional($data)->police_station); ?>" id="police_station" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Adress <b class="text-danger">*</b></label>
            <input type="text" name="address" value="<?php echo e(optional($data)->address); ?>" id="address" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Phone Number <b class="text-danger">*</b></label>
            <input type="text" name="phone" value="<?php echo e(optional($data)->phone); ?>" id="phone" class="form-control">
          </div>
          <div class="form-group position-relative">
            <label>National Id Card Photo<b class="text-danger">*</b></label>
            <?php if(isset($data)): ?> 
            <div class="edit-image">
              <a href="<?php echo e(asset('images'.$data->nid)); ?>">
                <img src="<?php echo e(asset('images'.$data->nid)); ?>" alt="">
              </a>
            </div> 
            <?php endif; ?> 
            <input type="file" name="nid" id="nid" class="form-control <?php echo e($image_class); ?> ">
          </div>
          <div class="form-group">
            <label for="">Status <b class="text-danger">*</b></label>
            <select name="status" id="status" class="form-control">
              <option value="1" <?php echo e(optional($data)->status == 1?'selected':''); ?>>Activate</option>
              <option value="0" <?php echo e(optional($data)->status == 0?'selected':''); ?>>Deactivate</option>
            </select>
          </div>
        </div>
      </div>
    </div>
    <div class="col-sm-6">
      <div class="mi-card">
        <div class="mi-header <?php echo e($data?'warning':'success'); ?>">
          BUSINESS INFORMATION
        </div>
        <div class="mi-body">
          <div class="form-group position-relative">
            <label>LOGO <b class="text-danger">*</b></label>
            <?php if($data): ?> 
            <div class="edit-image">
              <a href="<?php echo e(asset('images'.$data->logo)); ?>">
                <img src="<?php echo e(asset('images'.$data->logo)); ?>" alt="">
              </a>
            </div> 
            <?php endif; ?> 
            <input type="file" name="logo" id="logo" class="form-control <?php echo e($image_class); ?> ">
          </div>
          <div class="form-group">
            <label for="">Business Title/Name <b class="text-danger">*</b></label>
            <input type="text" name="business_title" value="<?php echo e(optional($data)->business_title); ?>" id="business_title" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Propiter Name <b class="text-danger">*</b></label>
            <input type="text" name="propiter_name" value="<?php echo e(optional($data)->propiter_name); ?>" id="propiter_name" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Business Division <b class="text-danger">*</b></label>
            <select name="business_division" id="business_division" class="form-control">
              <option value="">Select One</option>
              <?php $__currentLoopData = $divisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $division): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($division->id); ?>" <?php echo e($division->id == optional($data)->business_division?'selected':''); ?>><?php echo e($division->name); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
          <div class="form-group">
            <label for="">Business District <b class="text-danger">*</b></label>
            <select name="business_district" id="business_district" class="form-control">
              <option value="">Select One</option>
              <option :value="bdistrict.id" :selected="bdistrict.id == bdistrict_id" v-for="bdistrict in business_districts">{{bdistrict.name}}</option>
            </select>
          </div>
          <div class="form-group">
            <label for="">Business Police Station <b class="text-danger">*</b></label>
            <input type="text" name="business_police_station" value="<?php echo e(optional($data)->business_police_station); ?>" id="business_police_station" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Business Adress <b class="text-danger">*</b></label>
            <input type="text" name="business_address" value="<?php echo e(optional($data)->business_address); ?>" id="business_address" class="form-control">
          </div>
          <div class="form-group">
            <label for="">Business Contact <b class="text-danger">*</b></label>
            <input type="text" name="business_phone" value="<?php echo e(optional($data)->business_phone); ?>" id="business_phone" class="form-control">
          </div>
          <div class="form-group position-relative">
            <label>Trade license <b class="text-danger">*</b></label>
            <?php if(isset($data)): ?> 
            <div class="edit-image">
              <a href="<?php echo e(asset('images'.$data->trade_license)); ?>">
                <img src="<?php echo e(asset('images'.$data->trade_license)); ?>" alt="">
              </a>
            </div> 
            <?php endif; ?> 
            <input type="file" name="trade_license" id="trade_license" class="form-control <?php echo e($image_class); ?> ">
          </div>
          <div class="row">
            <div class="form-group col-sm-6">
              <label for="">Latitude <b class="text-danger">*</b></label>
              <input type="text" name="lat" value="<?php echo e(optional($data)->lat); ?>" id="lat" class="form-control">
            </div>
            <div class="form-group col-sm-6">
              <label for="">Longitude <b class="text-danger">*</b></label>
              <input type="text" name="lon" value="<?php echo e(optional($data)->lon); ?>" id="lon" class="form-control">
            </div>
          </div>

        </div>
      </div>
    </div>
    <div class="col-sm-12">
      <div class="mi-card">
        <div class="mi-header <?php echo e($data?'warning':'success'); ?>">
          SET DASHBOARD LOGN CREDENTIALS
        </div>
        <div class="mi-body">
          <div class="row">
            <div class="col-sm-6 form-group">
              <label for="">Email <b class="text-danger">*</b></label>
              <input type="email" name="email" id="email" value="<?php echo e(optional($data)->email); ?>" class="form-control">
            </div>
            <div class="col-sm-6 form-group">
              <label for="">Password <?php echo e($data?'(Enter password to reset password)':''); ?><b class="text-danger">*</b></label>
              <input type="password" name="password" value="" id="password" class="form-control">
            </div>
          </div>
        </div>
        <div class="mi-footer text-center">
            <?php if($data): ?>
            <button type="submit" class="butn warning">UPDATE DELLER INFO</button>
            <?php else: ?>
            <button type="submit" class="butn success">ADD NEW DELLER</button>
            <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</form>

<script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.6.3/axios.min.js" integrity="sha512-JWQFV6OCC2o2x8x46YrEeFEQtzoNV++r9im8O8stv91YwHNykzIS2TbvAlFdeH0GVlpnyd79W0ZGmffcRi++Bw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    var app = new Vue({
        el: '#app',
        data: {
            districts:[],
            business_districts:[],
            division_id : <?php echo json_encode(optional($data)->division, 15, 512) ?>,
            district_id : <?php echo json_encode(optional($data)->district, 15, 512) ?>,
            business_division_id : <?php echo json_encode(optional($data)->business_division, 15, 512) ?>,
            bdistrict_id : <?php echo json_encode(optional($data)->business_district, 15, 512) ?>

        },
        mounted(){
            // this.loadSubcategory(1);
            if(this.division_id){
                this.loadDistricts();
            }
            if(this.business_division_id){
                this.loadBusinessDistricts();
            }
            $('#division').on('change', this.loadDistricts);
            $('#business_division').on('change', this.loadBusinessDistricts);
        },
        methods:{
            loadDistricts(){
              const division_id = $('#division').val();
              var district_api = <?php echo json_encode(url('/api/districts'), 15, 512) ?>+'/'+division_id;
              axios.get(district_api).then((res)=>{
                  console.log(res.data);
                  this.districts = res.data.districts;
              },(error)=>{
                  console.log(error);
              })
            },

            loadBusinessDistricts(){
              const division_id = $('#business_division').val();
              var district_api = <?php echo json_encode(url('/api/districts'), 15, 512) ?>+'/'+division_id;
              axios.get(district_api).then((res)=>{
                  console.log(res.data);
                  this.business_districts = res.data.districts;
              },(error)=>{
                  console.log(error);
              })
            }
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.theme.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\projects\ezone\e-zone\resources\views/admin/delivery-hub/form.blade.php ENDPATH**/ ?>