@extends('theme.theme')
@section('content')

<div class="mi-card">
      <div class="mi-header info"> LIST OF PRODUCTS
        <a href="{{ route('seller.product.create') }}">
          <button class="butn success mi-right">ADD NEW PRODUCT</button>
        </a>
      </div>
      <div class="mi-body">
        <table class="mi-table table table-bordered table-striped" id="dataTable">
          <thead>
            <tr>
              <th>ID</th>
              <th>IMAGE</th>
              <th>PRODUCT NAME</th>
              <th>CATEGORY NAME</th>
              <th>SUBCATEGORY NAME</th>
              <th>PRICE</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach($products as $product) <tr>
              <td>{{ $product->id }}</td>
              <td><img width="70px" src="{{ optional($product->basicInfo)->thumbnail_url }}" alt=""></td>
              <td>
                <p><span>En:</span>{{ optional($product->basicInfo)->product_name_en }}</p>
                <p><span>Bn:</span>{{ optional($product->basicInfo)->product_name_bn }}</p>
              </td>
              <td>
                <p><span>En:</span>{{ optional($product->basicInfo->category)->category_name_en }}</p>
                <p><span>Bn:</span>{{ optional($product->basicInfo->category)->category_name_bn }}</p>
              </td>
              <td>
                <p><span>En:</span>{{ optional($product->basicInfo->subcategory)->subcategory_name_en }}</p>
                <p><span>Bn:</span>{{ optional($product->basicInfo->subcategory)->subcategory_name_bn }}</p>
              </td>

              <td>
                <p><span>Original Price:</span>{{ optional($product)->original_price }}</p>
                <p><span>Sale Price:</span>{{ optional($product)->sale_price }}</p>
              </td>

              <td class="mi-action-button">
                <a href="{{ route('product.edit',['id'=>$product->id]) }}">
                  <button class="butn warning transparent">
                    <i class="fa fa-edit"></i>
                  </button>
                </a>
                <a onclick="return confirm('Are you sure to delete')" href="{{ route('product.delete',['id'=>$product->id]) }}">
                  <button class="butn danger transparent">
                    <i class="fa fa-trash"></i>
                  </button>
                </a>
              </td>
            </tr>
            @endforeach
            </tbody>
        </table>
      </div>
    </div>
  </div>

@endsection
