@extends('hub.theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header">
        FUND REQUESTS
        <a href="{{ route('hub.fund.create') }}" class="mi-right butn success">MAKE A NEW REQUEST</a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th style="text-align:center">#</th>
                    <th>Date</th>
                    <th>Amount</th>
                    <th>Details</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($requests as $request)
                    <tr>
                        <td>{{ $request->id }}</td>
                        <td>{{ Carbon\Carbon::parse($request->date)->format('d M Y') }}</td>
                        <td>{{ $request->amount }}</td>
                        <td>{{ Str::limit($request->description, 20, '...') }}</td>
                        <td>{{ $request->status_text }}</td>
                        <td>
                            @if($request->status == FUND_REQUEST_PENDING)
                                <a href="{{ route('hub.fund.edit', ['id' => $request->id]) }}"><button class="butn warning butn-sm"><i class="fa fa-edit"></i></button></a>
                                <a onclick="deleteconfirm('{{ route('hub.fund.delete', ['id' => $request->id]) }}')"><button class="butn danger butn-sm"><i class="fa fa-trash"></i></button></a>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
