@extends('hub.theme.theme')
@section('content')
<div class="row">
    <div class="col-sm-6 m-auto">
        <div class="mi-card">
            <div class="mi-header">
                {{ $request ? 'UPDATE FUND REQUEST' : 'MAKE A FUND REQUEST' }}
            </div>
            <form action="{{ route('hub.fund.store', ['id' => $request?->id]) }}" method="post">
                @csrf
                <div class="mi-body">
                    <div class="form-group">
                        <label for="">Amount <b class="text-danger">*</b></label>
                        <input type="number" name="amount" id="amount" class="form-control" value="{{ $request?->amount }}" required>
                    </div>
                    <div class="form-group">
                        <label for="">Details</label>
                        <textarea name="description" id="description" class="form-control" rows="5">{{ $request?->description  }}</textarea>
                    </div>
                </div>
                <div class="mi-footer pos-right">
                    <button class="butn success {{ $request?'warning':'success' }}">SUBMIT</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
