@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        Flash wallet history
        <p class="mi-right">{{ $amount }}</p>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Order Id</th>
                    <th>Message</th>
                    <th>Amount</th>
                    <th>Current balance</th>
                </tr>
            </thead>
            <tbody>
                @foreach($transactions as $transaction)
                    <tr>
                        <td>{{ $transaction->id }}</td>
                        <td>{{ $transaction->order_id }}</td>
                        <td>{{ $transaction->message }}</td>
                        <td>{{ $transaction->amount }} ৳</td>
                        <td>{{ $transaction->current_balance }} ৳</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
