@extends('theme.theme')
@section('content')
    <style>
        .referrels{
            display: flex;
            gap: 10px;
            flex-wrap: wrap
        }
        .box{
            display: flex;
            align-items: center;
            background-color: #fff;
            padding: 10px;
            border-radius: 5px;
            gap:10px;
            flex-wrap: wrap;
        }
        .icon{
            width: 40px;
            height: 40px;
            background: #ff3d71;
            color: white;
            display: flex;
            justify-content: center;
            align-items: center;
            border-radius: 5px;
        }
        p{
            margin-bottom: 0px;
            color: #000;
            font-size: 14px;
        }
        .ref-label{
            font-family: Rubik !important;
            margin-block: 10px;
            text-transform: uppercase;
            font-weight: 600;
            font-size: 13;
        }
        .tab-content{
            padding: 10px !important;
        }
    </style>
    <div class="ps-2">
        <div class="box">
            <div class="icon">
                <i class="far fa-user"></i>
            </div>
            <div class="text">
                <p>{{$user->first_name}} {{$user->last_name}}</p>
                <p>+880 {{ $user->phone }}</p>
            </div>
        </div>
    </div>

    <div class="mi-card mt-3 ps-2">
        <div class="mi-header success transparent">
            TRANSACTION HISTORY
        </div>
        <div class="mi-body">
            <div class="mi-tab">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab" aria-controls="home" aria-selected="true">CASH WALLET HISTORY</button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab" aria-controls="profile" aria-selected="false">COMISSION WALLET HISTORY</button>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <table class="table mi-table table-bordered">
                            <thead>
                                <th>Date</th>
                                <th>Phone</th>
                                <th>Amount</th>
                                <th>T-ID</th>
                                <th>Message</th>
                                <th>Current Balance</th>
                                <th>Status</th>
                            </thead>
                            <tbody>
                                @foreach($cashWalletTransactions as $transaction)
                                <tr>
                                    <td style="font-weight: 500;white-space:nowrap">{{ date('d M Y',strtotime($transaction->created_at)) }}</td>
                                    <td>{{ $transaction->amount }}</td>
                                    <td>{{ $transaction->phone }}</td>
                                    <td>{{ $transaction->transaction_id }}</td>
                                    <td>{{ $transaction->message }}</td>
                                    <td>{{ $transaction->current_balance }}</td>
                                    <td>{{ $transaction->status_text }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                     <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <table class="table mi-table table-bordered">
                            <thead>
                                <th>Date</th>
                                <th>Order Id</th>
                                <th>Amount</th>
                                <th>Message</th>
                                <th>Current Balance</th>
                            </thead>
                            <tbody>
                                @foreach($comissionWalletHistory as $transaction)
                                <tr>
                                    <td style="font-weight: 500;white-space:nowrap">{{ date('d M Y',strtotime($transaction->created_at)) }}</td>
                                    <td>{{ $transaction->order_id }}</td>
                                    <td>{{ $transaction->amount }}</td>
                                    <td>{{ $transaction->message }}</td>
                                    <td>{{ $transaction->current_balance }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                     </div>
                </div>
            <div>
        </div>
    </div>
@endsection
