@extends('theme.theme')
@section('content')
<form action="{{ route('seller.store') }}" method="POST" enctype="multipart/form-data">
    @csrf
<div class="row">
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header {{ optional($data)->id?'warning':'success' }}">SELLER BASIC INFORMATION</div>
            <div class="mi-body">
                <input type="hidden" name="id" value="{{ optional($data)->id }}">
                <div class="row">
                    <div class="col-sm-6 ps-0 form-group">
                        <label for="">FIRST NAME <b class="text-danger">*</b></label>
                        <input type="text" class="form-control" name="first_name" value="{{ optional($data)->first_name }}">
                    </div>
                    <div class="col-sm-6 pe-0 form-group">
                        <label for="">LAST NAME <b class="text-danger">*</b></label>
                        <input type="text" class="form-control" name="last_name" value="{{ optional($data)->last_name }}">
                    </div>
                </div>
                <div class="form-group">
                    <label for="">EMAIL <b class="text-danger">*</b> </label>
                    <input type="email" class="form-control" name="email" value="{{ optional($data)->email }}">
                </div>
                <div class="form-group">
                    <label for="">PHONE <b class="text-danger">*</b></label>
                    <input type="text" class="form-control" name="phone" value="{{ optional($data)->phone }}">
                </div>
                <div class="form-group">
                    <label for="">PASSWORD @if(optional($data)->id) (Enter to reset the password) @else <b class="text-danger">*</b> @endif</label>
                    <input type="password" class="form-control" name="password">
                </div>
                <div class="form-group">
                    <label for="">CONFIRM PASSWORD @if(optional($data)->id) <b class="text-danger">*</b> @endif</label>
                    <input type="password" class="form-control" name="confirm_password">
                </div>
                <div class="form-group col-sm-">
                    <label>STATUS <b class="text-danger">*</b>
                    </label>
                    <select class="form-control" id="status" name="status" required>
                      <option selected>SELECT ONE </option>
                      <option value="1" {{ optional($data)->status == 1?'Selected':'' }}>Activate</option>
                      <option value="0" {{ optional($data)->status == 0?'Selected':'' }}>Deactivate</option>
                    </select>
                    <small class="text-dark">Note:if account is deactivated seller will not be able to login</small>
                  </div>
            </div>
        </div>
    </div>
    <div class="col-sm-6">
        <div class="mi-card">
            <div class="mi-header {{ optional($data)->id?'warning':'success' }}">SELLER SHOP INFORMATION</div>
            <div class="mi-body">
                <div class="form-group  position-relative">
                    <label>SHOP LOGO <b class="text-danger">*</b>
                    </label> @if(optional($data)->shop) <div class="edit-image">
                      <a href="{{ optional(optional($data)->shop)->shop_logo_url }}">
                        <img src="{{ optional(optional($data)->shop)->shop_logo_url }}" alt="">
                      </a>
                    </div> @endif <input type="file" name="shop_logo" id="shop_logo" class="form-control {{ optional($data)->shop?'edit-input':'' }} ">
                  </div>
                <div class="form-group">
                    <label for="">SHOP NAME (ENGLISH) <b class="text-danger">*</b></label>
                    <input type="text" class="form-control" name="shop_name_en" value="{{ optional(optional($data)->shop)->shop_name_en }}">
                </div>
                <div class="form-group">
                    <label for="">SHOP NAME (BANGLA) <b class="text-danger">*</b></label>
                    <input type="text" class="form-control" name="shop_name_bn" value="{{ optional(optional($data)->shop)->shop_name_bn }}">
                </div>
                <div class="form-group">
                    <label for="">SHOP ADDRESS <b class="text-danger">*</b></label>
                    <input type="text" class="form-control" name="shop_address" value="{{ optional(optional($data)->shop)->shop_address }}">
                </div>
                <div class="row">
                    <div class="col-sm-6 ps-0 form-group">
                        <label for="">LATITUDE <b class="text-danger">*</b></label>
                        <input type="text" class="form-control" name="lat" value="{{ optional(optional($data)->shop)->lat }}">
                    </div>
                    <div class="col-sm-6 pe-0 form-group">
                        <label for="">LONGITUDE <b class="text-danger">*</b></label>
                        <input type="text" class="form-control" name="lon" value="{{ optional(optional($data)->shop)->lon }}">
                    </div>
                </div>
                <div class="form-group col-sm-">
                    <label>STATUS <b class="text-danger">*</b>
                    </label>
                    <select class="form-control" id="status" name="shop_status" required>
                      <option selected>SELECT ONE </option>
                      <option value="1" {{ isset(optional($data)->shop) && optional(optional($data)->shop)->status == 1?'Selected':'' }}>Pubish</option>
                      <option value="0" {{ isset(optional($data)->shop) && optional(optional($data)->shop)->status == 0?'Selected':'' }}>Hide</option>
                    </select>
                    <small class="text-dark">Note:if shop is deactivated seller shop won't show up in agent app</small>
                  </div>
            </div>
        </div>
    </div>
    <div class="col-sm-12">
        <div class="mi-card">
            <div class="mi-footer text-center">
                <button type="submit" class="butn {{ isset($data)?'warning':'success' }}">SAVE SELLER INFO</button>
            </div>
        </div>
    </div>
</div>
</form>
@endsection
