@extends('theme.theme')
@section('content')
    @php
        $totalOrders = 0;
        $totalDelivered = 0;
        $totalCancelled = 0;
        $totalOnProcess = 0;
        $deliverdTotal = 0;
    @endphp
    <div class="mi-card">
        <div class="mi-header info">
            SALES REPORT
        </div>
        <div class="mi-body">
            <form action="" method="get">
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="">Start Date</label>
                        <input type="date" class="form-control" name="start_date" value="{{ request('start_date') }}">
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">End Date</label>
                        <input type="date" class="form-control" name="end_date" value="{{ request('end_date') }}">
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">Customer</label>
                        <select name="user_id" id="user_id" class="form-control">
                            <option value="">Select a customer</option>
                            @foreach($customers as $customer)
                            <option value="{{ $customer->id }}"  {{ request('user_id')==$customer->id?'selected':'' }}>{{ $customer->first_name }}  {{ $customer->last_name }} - {{ $customer->phone }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="">Shops</label>
                        <select name="shop_id" id="shop_id" class="form-control" >
                            <option value="">Select a shop</option>
                            @foreach($shops as $shop)
                            <option {{ request('shop_id')==$shop->id?'selected':'' }} value="{{ $shop->id }}">{{ $shop->shop_name_en }}</option>
                            @endforeach
                        </select>
                    </div>

                </div>
                <div class="d-flex" style="justify-content: flex-end;gap:10px">
                    <a href="{{ route('report.customer.sales-report') }}"><button class="butn butn-sm danger">Clear</button></a>
                    <button class="butn butn-sm success">Filter</button>
                </div>
            </form>


            @if($data)
            <div class="mt-3">
                <table class="table mi-table table-bordered " id="dataTable">
                    <thead>
                        <th>Date</th>
                        <th>Deivered Order</th>
                        <th>Inprogress Order</th>
                        <th>Cancelled Order</th>
                        <th>Cancelled Total</th>
                        <th>Delivered Total</th>
                    </thead>
                    <tbody>
                        @foreach($data as $item)
                        @php
                            $totalOrders += (int)$item->total_orders;
                            $totalDelivered += (int)$item->delivered_orders;
                            $totalCancelled += (int)$item->cancelled_orders;
                            $totalOnProcess += (int)$item->other_orders;
                            $deliverdTotal += (float)$item->delivered_orders_total
                        @endphp
                        <tr>
                            <td>{{ $item->date }}</td>
                            <td>{{ $item->delivered_orders }}</td>
                            <td>{{ $item->other_orders }}</td>
                            <td>{{ $item->cancelled_orders }}</td>
                            <td>{{ $item->cancelled_orders_total }}</td>
                            <td>{{ $item->delivered_orders_total }}</td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>

                <div class="mi-box mt-5">
                    <div class="referrels gray-box">
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Total Orders</p>
                                <h6>{{ $totalOrders }}</h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Delivered Orders</p>
                                <h6>{{ $totalDelivered }}</h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Cancelled Orders</p>
                                <h6>{{ $totalCancelled }}</h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>On Process</p>
                                <h6>{{ $totalOnProcess }}</h6>
                            </div>
                        </div>
                        <div class="box">
                            <div class="icon">
                                <i class="far fa-user"></i>
                            </div>
                            <div class="text">
                                <p>Delivered Total</p>
                                <h6>{{ $deliverdTotal }}</h6>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
@endsection
