@extends('theme.theme')
@section('content')
<div class="row">
    <div class="col-sm-6 m-auto">
        <div class="mi-card">
            <div class="mi-header info">
                {{ $rank ? 'Edit Rank' : 'Add Rank' }}
            </div>
            <form action="{{ route('admin.rank.store', ['id' => $rank?->id]) }}" method="POST">
                @csrf
                <div class="mi-body">
                    <div class="form-group">
                        <label for="">Name <b class="text-danger">*</b></label>
                        <input type="text" name="name" id="name" class="form-control" value="{{ $rank?->name }}" required>
                    </div>
                    <div class="form-group">
                        <label for="">Type <b class="text-danger">*</b></label>
                        <select name="type" id="type" class="form-control" required>
                            <option value="">Select Type</option>
                            @foreach(getRankTypes() as $key => $value)
                                <option value="{{ $key }}" {{ $rank?->type == $key ? 'selected' : '' }}>{{ $value }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="">Team A Amount <b class="text-danger">*</b></label>
                        <input type="number" name="team_A_amount" id="team_A_amount" class="form-control" value="{{ $rank?->team_A_amount }}" required>
                    </div>
                    <div class="form-group">
                        <label for="">Team B Amount <b class="text-danger">*</b></label>
                        <input type="number" name="team_B_amount" id="team_B_amount" class="form-control" value="{{ $rank?->team_A_amount }}" required>
                    </div>

                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success">SAVE</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
