@extends('theme.theme')
<?php
  if($data){
  }else{
    $status = "success";
  }
?>

@section('content')
<style>
    .select2-container {
        z-index: 1 !important;
    }
</style>
<form action="{{ route('product.store') }}" method="post" id="app" enctype="multipart/form-data">
  @csrf
  @if($data)
    <input type="hidden" name="id" value="{{ $data->id }}">
  @endif
  <div class="row" style="padding-bottom:70px;" >
    <div class="col-sm-8">
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">
          PRODUCT BASIC INFORMATION <small>(You cant change this section)</small>
          @if(!$data)
          <button type="button" class="butn danger mi-right" data-bs-toggle="modal" data-bs-target="#selectProductModal">SELECT PRODUCT</button>
          @endif
        </div>
        <div class="mi-body">
          <div class="row">
            <div class="form-group col-sm-6">
                <label for="">COMPANY NAME</label>
                <select name="company" id="company" class="form-control">
                    <option value="">Select One Company</option>
                    @foreach($companies as $company)
                        <option value="{{ $company->id }}" {{ optional($data)->company_id == $company->id?'selected':'' }}>{{ $company->name }}</option>
                    @endforeach
                </select>
            </div>
            <div :class="{'form-group col-sm-6':true,'d-none':!company_id}">
                <label>SELECT BRAND <b class="text-danger">*</b></label>
                <select class="form-control" id="brand_id"  name="brand_id">
                    <option value="" selected>Select one</option>
                    <option v-for="(brand, index) in brands" :selected="brand_id==brand.id" :value="brand.id">@{{ brand.brand_name_en }}</option>
                </select>
            </div>
            <div :class="{'form-group col-sm-6':true,'d-none':!brand_id}" >
                <label>SELECT CATEGORY <b class="text-danger">*</b></label>
                {{-- <input type="text" name="category_id" id="category_id" v-model="category_id"> --}}
                <select class="form-control" id="category_id"  name="category_id"  required>
                    <option value="" selected>Select one</option>

                    @foreach($categories as $option)
                    <option value="{{ $option->id }}" {{ optional($data)->category_id == $option->id?'selected':'' }}>
                        {{ $option->category_name_en }}
                    </option>
                    @endforeach
                </select>
            </div>
            <div class="form-group  col-sm-6" :class="{'form-group col-sm-6':true,'d-none':!category_id}">
                <label>SELECT SUBCATEGORY <b class="text-danger">*</b></label>
                <select class="form-control" id="subcategory_id" name="subcategory_id"  v-on:change="loadProduct()" required>
                    <option value="" selected>Select one</option>
                    <option v-for="subcategory in subcategories" :selected="subcategory.id == subcategory_id" :value="subcategory.id">
                    @{{ subcategory.subcategory_name_en }}
                    </option>
                </select>
            </div>

            <div :class="{'form-group':true,'d-none':!subcategory_id}">
                <label>SELECT YOUR PRODUCT <b class="text-danger">*</b></label>
                <select class="form-control" id="product_id" name="product_id"  required>
                    <option selected>Select a product </option>
                    <option v-for="product in products" :selected="product.id == product_id" :value="product.id">
                            @{{ product.product_name_en }} -
                            @{{ product.product_name_bn }}
                    </option>
                </select>
            </div>

            <div :class="{'form-group col-sm-12':true,'d-none':!product_id}" >
                <div class="mb-3">
                    <img :src="thumbnail_image_url" height="150px" v-if="thumbnail_image_url" >
                </div>
                <button  type="button" class="butn danger" data-bs-toggle="modal" data-bs-target="#exampleModal">
                    Select product thumbnail
                </button>
            </div>

            <div :class="{'form-group col-sm-12':true,'d-none':!product_id}">
                <div class="d-flex gap-2 mb-2 flex-wrap">
                    <img :src="selectedImage.file_url" style="height: 100px" v-for="selectedImage of selectedImages" v-if="selectedImage.file_url">
                </div>
                <button type="button" class="butn danger" data-bs-toggle="modal" data-bs-target="#imagesModal">
                    Select product images
                </button>
            </div>
            <input type="hidden" name="thumbnail" id="thumbnail">
            <input type="hidden" name="images" id="images">
          </div>
        </div>
      </div>
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">ENTER PRODUCT INFORMATION</div>
        <div class="mi-body">
          <div class="row">
            <div class="form-group col-sm-6">
              <label for="">ENTER PRODUCT DETAILS</label>
              <input type="text" name="details_one_title" class="form-control mb-1" value="{{ optional($data)->details_one_title }}" placeholder="Enter The Title Here">
              <textarea name="details_one" id="details" rows="5" class="form-control" placeholder="Write the details here">{{ optional($data)->details_one }}</textarea>
            </div>
            <div class="form-group col-sm-6">
              <label for="">ENTER PRODUCT DETAILS</label>
              <input type="text" name="details_two_title" class="form-control mb-1" value="{{ optional($data)->details_two_title }}" placeholder="Enter The Title Here">
              <textarea name="details_two" id="details" rows="5" class="form-control" placeholder="Write the details here">{{ optional($data)->details_two }}</textarea>
            </div>
            <div class="form-group col-sm-6">
              <label for="">ENTER PRODUCT DETAILS</label>
              <input type="text" name="details_three_title" class="form-control mb-1" value="{{ optional($data)->details_three_title }}" placeholder="Enter The Title Here">
              <textarea name="details_three" id="details_three" rows="5" class="form-control" placeholder="Write the details here">{{ optional($data)->details_three }}</textarea>
            </div>
            <div class="col-sm-6">
                <div class="form-group">
                    <label for="">SET WARRANTY TIME (DAYS)</label>
                    <div class="input-group">
                      <input type="number" name="warranty_time" id="warranty_time" class="form-control" value="{{ optional($data)->warranty_time }}">
                      <span class="input-group-text" id="basic-addon1">Days</span>
                    </div>
                </div>
                <div class="form-group">
                    <label for="">SET REFUND TIME (DAYS)</label>
                    <div class="input-group">
                        <input type="number" name="refund_time" id="refund_time" class="form-control" value="{{ optional($data)->refund_time }}">
                        <span class="input-group-text" id="basic-addon1">Days</span>
                    </div>
                </div>
                <div class="form-group">
                    <label for="">TAG</label>
                    <input type="tag" name="tag" id="tag" class="form-control" value="{{ optional($data)->tag }}">
                    <small class="text-danger">It will Show Before Product Name</small>
                </div>
            </div>


            <div class="col-sm-6 form-group">
              <label for="">PURCHASE PRICE</label>
              <div class="input-group">
                <input type="number" name="original_price" id="original_price" class="form-control" value="{{ optional($data)->original_price }}">
                <span class="input-group-text" id="basic-addon1">৳</span>
              </div>
            </div>
            <div class="col-sm-6 form-group">
              <label for="">SALE PRICE</label>
              <div class="input-group">
              <input type="number" name="sale_price" id="sale_price" class="form-control" value="{{ optional($data)->sale_price }}">
              <span class="input-group-text" id="basic-addon1">৳</span>
              </div>

            </div>

          </div>

        </div>
      </div>
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">SET PRODUCT ATTRIBUTE</div>
        <div class="mi-body">
          <div class="form-group">
            <label for="">SIZES</label>
            <select name="sizes[]" multiple id="sizes" class="form-control">
              <option value="">SELECT SIZES</option>
              @foreach($sizes as $size)
              <option value="{{ $size->size_name }}">{{ $size->size_name }}</option>
              @endforeach
            </select>
          </div>
          <div class="form-group">
            <label for="">COLORS</label>
            <select name="colors[]" multiple id="colors" class="form-control">
              <option value="">SELECT COLORS</option>
              @foreach($colors as $color)
              <option value="{{ $color->id }}">{{ $color->color_name }}</option>
              @endforeach
            </select>
          </div>

          <div>
            @foreach($data?->colors ?? [] as $productColor)
                <div class="mi-card mb-2">
                    <div class="mi-body d-flex justify-content-between align-items-center px-3 py-1">
                        <div class="d-flex align-items-center gap-2">
                            <a onclick="return confirm('Are you sure to delete')" href="{{ route('product.delete.color',['id'=>$productColor->id]) }}">
                                <i class="fa fa-trash text-danger"></i>
                            </a>
                            <p class="mb-0" style="color: #000">{{ $productColor?->color?->color_name }}</p>
                        </div>
                        <img src="{{ $productColor->image_url }}" width="50px" alt="">
                    </div>
                </div>
            @endforeach
            <div class="mi-card mb-2" v-for="(color,index) in selected_colors">
                <div class="mi-body d-flex justify-content-between align-items-center">
                    <p class="mb-0" style="color: #000">@{{ color.color_name }}</p>
                    <input type="hidden" name="color_ids[]" :value="color.id">
                    <input type="file" name="color_images[]" class="form-control" style="width:300px !important" required>
                </div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <div class="col-sm-4">
      <div class="mi-card">
            <div class="mi-header {{ $status }} transparent">RESELLER APP</div>
            <div class="mi-body">
              <div class="form-group">
                  <label for="">SPOT COMISSION </label>
                  <div class="input-group">
                  <input type="number" class="form-control" value="{{optional($data)->spot_comission}}" name="spot_comission">
                  <span class="input-group-text" id="basic-addon1">%</span>
                  </div>
              </div>
              <div class="form-group">
                  <label for="">TEAM COMISSION </label>
                  <div class="input-group">
                  <input type="number" class="form-control" value="{{optional($data)->team_comission}}" name="team_comission">
                  <span class="input-group-text" id="basic-addon1">%</span>
                  </div>
              </div>
            </div>
      </div>
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">CUSTOMER APP</div>
        <div class="mi-body">
          <div class="form-group">
            <label for="">DISCOUNT </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->customer_discount}}" name="customer_discount" >
            <span class="input-group-text" id="basic-addon1">%</span>
            </div>
          </div>
        </div>
      </div>
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">AGENT APP</div>
        <div class="mi-body">
          <div class="form-group">
            <label for="">DISCOUNT </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->agent_discount}}" name="agent_discount" >
            <span class="input-group-text" id="basic-addon1">%</span>
            </div>
          </div>
        </div>
      </div>
      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">DROPSHIPPER PANEL</div>
        <div class="mi-body">
          <div class="form-group">
            <label for="">DiSCOUNT </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->dropshipper_discount}}" name="dropshipper_discount" >
            <span class="input-group-text" id="basic-addon1">%</span>
            </div>
          </div>
          <div class="form-group">
            <label for="">MINIMUM SELL PRICE </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->dropshipper_min_price}}" name="dropshipper_min_price" >
            <span class="input-group-text" id="basic-addon1">৳</span>
            </div>
          </div>
          <div class="form-group">
            <label for="">MAXIMUM SELL PRICE </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->dropshipper_max_price}}" name="dropshipper_max_price" >
            <span class="input-group-text" id="basic-addon1">৳</span>
            </div>
          </div>
          <div class="form-group">
            <label for="">MINIMUM PRE PAYMENT </label>
            <div class="input-group">
            <input type="number" class="form-control" value="{{optional($data)->dropshipper_pre_payment}}" name="dropshipper_pre_payment" >
            <span class="input-group-text" id="basic-addon1">৳</span>
            </div>
          </div>
        </div>
      </div>
       <div class="mi-card">
            <div class="mi-header {{ $status }} transparent">STOCK</div>
            <div class="mi-body">
                <input type="number" class="form-control" value="{{optional($data)->stock}}" name="stock">
            </div>
       </div>

      <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">FREE DELIVER</div>
        <div class="mi-body">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" id="is_free_delivery" name="is_free_delivery" v-model="form.is_free_delivery" {{ optional($data)->is_free_delivery?'checked':'' }} @change="setFreeDelivery()">
            <label class="form-check-label" for="is_free_delivery">
              Delivery is free for this product
            </label>
          </div>

          {{-- <div class="form-group" v-if="show_free_delivery_quantity">
            <label for="">Free Delivery Quantity</label>
            <input type="number" class="form-control" name="free_delivery_quantity"  value="{{optional($data)->free_delivery_quantity ?? 1}}">
          </div> --}}

        </div>
      </div>

       <div class="mi-card">
        <div class="mi-header {{ $status }} transparent">PRODUCT STATUS</div>
        <div class="mi-body">
          <div class="form-check">
            <input class="form-check-input" type="checkbox" name="is_featured" value="1" {{ optional($data)->is_featured?'checked':'' }} id="ee">
            <label class="form-check-label" for="ee">
              THIS IS A FEATURED PRODUCT
            </label>
          </div>
          <div class="form-check">
            <input class="form-check-input" name="show_in_home" type="checkbox" value="1" {{ optional($data)->show_in_home?'checked':'' }} id="dd" >
            <label class="form-check-label" for="dd">
              SHOW THIS PRODUCT IN APP HOME
            </label>
          </div>

          <div class="form-group">
            <label for="">PRODUCT STATUS</label>
            <select name="status" id="status" class="form-control">
              <option value="1" {{ optional($data)->status == 1?'selected':'' }}>Active</option>
              <option value="0" {{ optional($data)->status == 0?'selected':'' }}>Deactive</option>
            </select>
          </div>
        </div>
      </div>
    </div>

  </div>

  <div class="buttons" style="position: fixed;bottom: 10px;right: 10px;background: #fff;padding: 15px;box-shadow: rgba(17, 17, 26, 0.1) 0px 4px 16px, rgba(17, 17, 26, 0.05) 0px 8px 32px;">
    <a href="{{route('product.list')}}">
      <button type="button" class="butn danger">CANCEL & GO BACK</button>
    </a>
    @if($data)
    <button type="submit" class="butn warning">UPDATE PRODUCT</button>
    @else
    <button type="submit" class="butn success">ADD NEW PRODUCT</button>
    @endif

  </div>


<div class="modal fade" id="selectProductModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document" style="max-width:95%">
    <div class="modal-content mi-card">
      <div class="modal-header mi-header danger transparent">
        SELECT PRODUCT
        {{-- <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button> --}}
      </div>
      <div class="mi-body">
        <input type="text" class="form-control mb-3" placeholder="Search ...." v-model="search" @keyup="filterProduct()">
        <div class="row">
            <div class="col-sm-2 mb-2" v-for="product in filterProducts">
                <div class="product-card" @click="selectProduct(product)">
                    <img :src="product.thumbnails?.[0]?.file_url" alt="" width="100%">
                    <div class="text">
                        @{{ product.product_name_en }}
                    </div>
                </div>
            </div>
        </div>
      </div>
      <div class="mi-footer">
        <button type="button" class="butn danger d-flex justify-content-end" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title media-title" id="exampleModalLabel">PLEASE SELECT A IMGAE FOR THUMBNAIL</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" v-if="selectedProduct">
        <div class="row">
            <div :class="{'form-check image-check':true,'selected-image':thumbnail_image_id==thumbnail.id}" v-for="thumbnail in selectedProduct.thumbnails" style="width:max-content" v-on:click="selectThumbnail(thumbnail)">
                <input class="form-check-input d-none" type="radio" :value="thumbnail.id" :name="`flexRadioDefault`+thumbnail.id" id="`flexRadioDefault`+thumbnail.id">
                <label class="form-check-label" :for="`flexRadioDefault`+thumbnail.id">
                    <img :src="thumbnail?.file_url" style="height: 135px">
                </label>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="butn primary" data-bs-dismiss="modal">Done</button>
      </div>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="imagesModal" tabindex="-1" aria-labelledby="imagesModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title media-title" id="imagesModalLabel">PLEASE SELECT MAXIMUM 5 PRODUCT IMAGES</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body" v-if="selectedProduct?.images?.length>0">
        <div class="row gap-2">
            <div :class="{'form-check image-check':true,'selected-image':isSelectedImage(image.id)}" v-for="image in selectedProduct.images" style="width:max-content" v-on:click="selectImage(image)">
                <input class="form-check-input d-none" type="checkbox" :value="image.id" :name="`flexRadioDefault`+image.id" id="`flexRadioDefault`+image.id">
                <label class="form-check-label" :for="`flexRadioDefault`+image.id">
                    <img :src="image?.file_url" style="height: 135px">
                </label>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        <button type="button" class="butn primary" data-bs-dismiss="modal">Done</button>
      </div>
    </div>
  </div>
</div>

</form>



@php
  $selectedSizes = [];
  if(optional($data)->sizes){
    $selectedSizes = explode(',',optional($data)->sizes);
  }

  $selectedColors = [];
  if(optional($data)->colors){
    $selectedColors = explode(',',optional($data)->colors);
  }
@endphp

<script>
var colors = <?= json_encode($colors) ?>;
  $(document).ready(function(){
    var sizes = <?= json_encode($selectedSizes) ?>;
    $('#sizes').val(sizes).trigger('change');
    // $('#colors').val(colors).trigger('change');
  })
</script>

<script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.6.3/axios.min.js" integrity="sha512-JWQFV6OCC2o2x8x46YrEeFEQtzoNV++r9im8O8stv91YwHNykzIS2TbvAlFdeH0GVlpnyd79W0ZGmffcRi++Bw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script>
    var app = new Vue({
        el: '#app',
        data(){
            return {
                form:{
                    brand_id:0,
                    is_free_delivery:0
                },
                show_free_delivery_quantity:false,
                brands:[],
                categories:[],
                subcategories:[],
                products:@Json($products),
                filterProducts:@Json($products),
                search:'',
                category_id:null,
                subcategory_id:null,
                company_id:null,
                brand_id:null,
                product_id:null,
                selectedProduct:{},
                thumbnail_image_id:null,
                thumbnail_image_url:null,
                selectedImages:[],
                _thumbnail:null,
                _images:null,
                colors:colors,
                selected_colors:[]
            }
        },
        mounted(){
            var data = @Json($data);
            this.categories = @Json($categories);

            if(data){
                if(data.is_free_delivery) {
                    this.show_free_delivery_quantity = true;
                    this.form.is_free_delivery = true;
                }
                this.subcategories = @Json(optional($subcategories));
                this.products = @Json(optional($products));
                this.category_id = data.category_id;
                this.subcategory_id = data.subcategory_id;
                this.company_id = data.company_id;
                this.brand_id = data.brand_id;
                this.product_id = data.basic_info_id;
                this.selectedImages = data._images;
                this.thumbnail_image_id = data.thumbnail;
                this.thumbnail_image_url = data.thumbnail_url;
                $('#thumbnail').val(this.thumbnail_image_id);
                $('#images').val(JSON.stringify(this.selectedImages));
                if(this.company_id){
                    this.loadBrand(this.company_id)
                }
                if(this.category_id){
                    this.loadSubcategory(this.category_id)
                }
                if(this.subcategory_id){
                    this.loadProduct();
                    // $('#product_id').val(this.product_id).change();
                }

            }



            $('#company').on('change', (event)=>{
                this.loadBrand()
            });

            $('#colors').on('change', () => {
                // this.selected_colors = $('#colors').val();
                this.setColors($('#colors').val());
            });

            $('#brand_id').on('change', (event) => {
                this.brand_id = event.target.value;
                this.loadProduct();
            });

            $('#category_id').on('change', (event) => {
                this.category_id = event.target.value;
                this.loadSubcategory();
            });

            $('#subcategory_id').on('change', (event) => {
                this.subcategory_id = event.target.value;
                this.loadProduct();
            });
            $('#product_id').on('change', (event) => {
                this.product_id = event.target.value;
                this.selectedProduct = this.products.find(p => p.id === parseInt(this.product_id));
            });
        },
        methods:{
            loadBrand(){
                const company_id = $('#company').val();
                var brandUrl = @Json(url('/api/brands'))+'/'+company_id
                axios.get(brandUrl).then((res)=>{
                    this.company_id = company_id;
                    this.brands = res.data.data;
                },(error)=>{
                    console.log(error);
                })

            },

            loadSubcategory(){
                const category_id = $('#category_id').val();
                var subcategory_url = @Json(url('/api/subcategories'))+'/'+category_id
                console.log(subcategory_url);
                axios.get(subcategory_url).then((res)=>{
                    this.subcategories = res.data.data;
                },(error)=>{
                    console.log(error);
                })
            },

            loadProduct(){
                var product_url = @Json(url('/api/basic-products'))+`?category_id=${this.category_id}&subcategory_id=${this.subcategory_id}&brand_id=${this.brand_id}&product_id=${this.product_id}`;
                axios.get(product_url).then((res)=>{
                    this.products = res.data.products;
                    this.selectedProduct = this.products.find(p => p.id === parseInt(this.product_id));
                },(error)=>{
                    console.log(error);
                })
            },

            selectThumbnail(thumbnail){
                this.thumbnail_image_id = thumbnail.id;
                this.thumbnail_image_url = thumbnail.file_url;
                $('#thumbnail').val(this.thumbnail_image_id)
            },

            selectImage(image) {
                const index = this.selectedImages.findIndex(selectedImage => selectedImage.id === image.id);
                if (index === -1) {
                    // Image not found in selected images array, so add it
                    this.selectedImages.push({
                        id: image.id,
                        file_url:image?.file_url,
                        file_path:image?.file_path
                    });
                } else {
                    // Image found in selected images array, so remove it
                    this.selectedImages.splice(index, 1);
                }

                $('#images').val(JSON.stringify(this.selectedImages))
            },

            isSelectedImage(imageId) {
                console.log(this.selectedImage);
                return this.selectedImages.some(image => image.id === imageId);
            },

            selectProduct(product){
                axios.get(`/admin/product/details/${product.id}`).then((res)=>{
                    this.products = res.data?.products;
                    this.company_id = res.data.product?.company_id;
                    this.brands = res.data?.brands;
                    this.subcategories = res.data?.subcategories;
                    this.category_id = res.data?.product?.category_id;
                    this.brand_id = res.data?.product?.brand_id;
                    this.subcategory_id = res.data?.product?.subcategory_id;
                    this.selectedProduct = res.data?.product;
                    this.product_id = res.data?.product?.id;
                    $('#category_id').val(this.category_id).change();
                    $('#company').val(this.company_id).change();
                    $('#product_id').val(this.product_id).change();
                    this.$forceUpdate()
                    $('#selectProductModal').modal('hide');
                })
            },

            filterProduct(){
                if(this.search && this.search.trim() !== ''){
                    const filterItems = this.products.filter(product => {
                    const searchTerm = this.search.toLowerCase();
                        return (
                            product.product_name_en.toLowerCase().includes(searchTerm) ||
                            product.product_name_bn.toLowerCase().includes(searchTerm)
                        );
                    });
                    this.filterProducts = filterItems;
                }else{
                    this.filterProducts = this.products;
                }
            },

            setFreeDelivery(){
                if(this.form.is_free_delivery){
                    this.show_free_delivery_quantity = true;
                }else{
                    this.show_free_delivery_quantity = false;
                }
            },

            setColors(selectedColors){
                const mySeledctedColors = [];
                selectedColors.map((selectedColor)=>{
                    // console.log(selectedColor);
                    const matchedColor = this.colors.find(color => color.id == selectedColor);
                    if(matchedColor){
                        mySeledctedColors.push(matchedColor);
                    }
                });

                this.selected_colors = mySeledctedColors;
            }
        }
    });
</script>
@endsection
