@extends('theme.theme')
@section('content')

    <form action="{{ route('product-basic-info.store') }}" method="POST" enctype="multipart/form-data">
        @if($data)
        <input type="hidden" name="id" value="{{$data->id}}">
        @endif
        @csrf
        <div class="row">
            <div class="col-sm-6" id="app">
                <div class="mi-card">
                    <div class="mi-header success">
                        {{ optional($data)?'ADD':'EDIT' }} PRODUCT INFO
                    </div>
                    <div class="mi-body">
                            <div class="form-group">
                                <label for="">COMPANY NAME <b class="text-danger">*</b></label>
                                <select name="company" id="company" class="form-control"  >
                                    <option value="">Select One Company</option>
                                    @foreach($companies as $company)
                                        <option value="{{ $company->id }}" {{ optional($data)->company_id == $company->id?'selected':'' }}>{{ $company->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class=" form-group">
                                <label for="">PRODUCT NAME (ENGLISH) <b class="text-danger">*</b></label>
                                <input type="text" placeholder="Product name - english" name="product_name_en" class="form-control" value="{{ old('product_name_en') ?? optional($data)->product_name_en}}" >
                            </div>

                            <div class=" form-group">
                                <label for="">PRODUCT NAME (BANGLA) <b class="text-danger">*</b></label>
                                <input type="text" placeholder="Product name - bangla" name="product_name_bn" class="form-control" value="{{ old('product_name_bn') ?? optional($data)->product_name_bn}}" >
                            </div>

                            <div class="form-group ">
                                <label>SELECT CATEGORY <b class="text-danger">*</b></label>
                                <select class="form-control" id="category_id"  name="category_id"  >
                                    <option value="" selected>SELECT ONE </option>
                                    @foreach($categories as $option)
                                    <option value="{{ $option->id }}" {{ optional($data)->category_id == $option->id?'selected':'' }}>
                                        {{ $option->category_name_en }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group ">
                                <label>SELECT SUBCATEGORY <b class="text-danger">*</b></label>
                                <select class="form-control" id="subcategory_id" name="subcategory_id" >
                                    <option value="" selected>SELECT ONE </option>
                                    <option v-for="subcategory in subcategories" :selected="subcategory.id == subcategory_id" :value="subcategory.id">
                                        @{{ subcategory.subcategory_name_en }}
                                    </option>
                                </select>
                            </div>

                            <div class="form-group ">
                                <label>SELECT BRAND <b class="text-danger">*</b></label>
                                <select class="form-control" id="brand_id" name="brand_id" >
                                    <option value="" selected>SELECT ONE </option>
                                    <option v-for="brand in brands" :selected="brand.id == brand_id" :value="brand.id">
                                        @{{ brand.brand_name_en }}
                                    </option>
                                </select>
                            </div>


                    </div>
                </div>
            </div>
            <div class="col-sm-6" id="app">
                <div class="mi-card">
                    <div class="mi-header success">
                        {{ optional($data)?'ADD':'EDIT' }} PRODUCT IMAGE
                    </div>
                    <div class="mi-body">
                        @if(optional($data)->thumbnails)
                        <div class="d-flex flex-wrap gap-2 mb-3">
                            @foreach(optional($data)->thumbnails as $image)
                            <div style="width: 150px;border-radius: 10px;overflow: hidden;position:relative">
                                <img width="100%" src="{{ $image->file_url }}" alt="">
                                <a onclick="return confirm('Are you sure to delete ?')"  href="{{ route('product-basic-info.delete-image',['id'=>$image->id]) }}">
                                    <button type="button" class="butn butn-sm danger" style="position: absolute;top: 0;right: 0;"><i class="fa fa-trash"></i></button>
                                </a>
                            </div>
                            @endforeach
                        </div>
                        @endif
                        <div class="form-group position-relative">
                            <label>PRODUCT THUMBNAIL <b class="text-danger info-text">(You can upload multiple image)*</b></label>
                            <input type="file" name="thumbnail[]" multiple id="thumbnail" class="form-control {{ optional($data)->thumbnail?'edit-input':'' }} ">
                            <small class="text-success">Image dimansion must be 375x375 px</small>
                        </div>

                        @if(optional($data)->images)
                        <div class="d-flex flex-wrap gap-2 mb-3">
                            @foreach(optional($data)->images as $image)
                            <div style="width: 150px;border-radius: 10px;overflow: hidden;position:relative">
                                <img width="100%" src="{{ $image->file_url }}" alt="">
                                <a onclick="return confirm('Are you sure to delete ?')"  href="{{ route('product-basic-info.delete-image',['id'=>$image->id]) }}">
                                    <button type="button" class="butn butn-sm danger" style="position: absolute;top: 0;right: 0;"><i class="fa fa-trash"></i></button>
                                </a>
                            </div>
                            @endforeach
                        </div>
                        @endif
                        <div class="form-group position-relative">
                            <label>PRODUCT IMAGES <b class="text-danger info-text"> (You can upload multiple image)</b></label>
                            <input type="file" multiple name="images[]" id="images" class="form-control">
                            <small class="text-success">Image dimansion must be 1200x675 px</small>
                        </div>

                        <div class="form-group">
                            <label for="">STATUS</label>
                            <select name="status" id="status" class="form-control">
                            <option value="1" {{ optional($data)->status == 1?'selected':'' }}>Active</option>
                            <option value="0" {{ optional($data)->status == 0?'selected':'' }}>Deactive</option>
                            </select>
                        </div>

                    </div>
                    <div class="mi-footer text-center">
                        <button type="submit" class="butn success">SAVE DATA</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <script src="https://cdn.jsdelivr.net/npm/vue@2"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/1.6.3/axios.min.js" integrity="sha512-JWQFV6OCC2o2x8x46YrEeFEQtzoNV++r9im8O8stv91YwHNykzIS2TbvAlFdeH0GVlpnyd79W0ZGmffcRi++Bw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script>
        var app = new Vue({
            el: '#app',
            data: {
                subcategories:[],
                brands:[],
                category_id : @Json(optional($data)->category_id),
                brand_id : @Json(optional($data)->brand_id),
                subcategory_id : @Json(optional($data)->subcategory_id),
                company_id : @Json(optional($data)->company_id)
            },
            mounted(){
                if(this.category_id){
                    this.loadSubcategory(this.category_id)
                }
                if(this.company_id){
                    this.loadBrand(this.company_id)
                }
                $('#category_id').on('change', this.loadSubcategory);
                $('#company').on('change', this.loadBrand);
            },
            watch: {
                brands() {
                    this.$nextTick(() => {
                        const vm = this;
                        if ($('#brand_id').hasClass("select2-hidden-accessible")) {
                            $('#brand_id').select2('destroy');
                        }
                        $('#brand_id').select2();
                    });
                },
                subcategories() {
                    this.$nextTick(() => {
                        const vm = this;
                        if ($('#subcategory_id').hasClass("select2-hidden-accessible")) {
                            $('#subcategory_id').select2('destroy');
                        }
                        $('#subcategory_id').select2();
                    });
                }
            },
            methods:{
                loadSubcategory(){
                    this.subcategories = [];
                    const category_id = $('#category_id').val();
                    var subcategory_url = @Json(url('/api/subcategories'))+'/'+category_id
                    axios.get(subcategory_url).then((res)=>{
                        this.subcategories = res.data.data;
                        this.$forceUpdate();
                    },(error)=>{
                        console.log(error);
                    })
                },

                loadBrand(){
                    const company_id = $('#company').val();
                    var brandUrl = @Json(url('/api/brands'))+'/'+company_id
                    axios.get(brandUrl).then((res)=>{
                        this.brands = res.data.data;
                    },(error)=>{
                        console.log(error);
                    })

                }
            }
        });
    </script>

@endsection
