@extends('theme.theme')
@section('content')
<style>
    p{
        margin-bottom: 1px;
        font-family: 'Rubik';
        font-weight: 400;
        text-align: left;
    }
    span{
        color: #ccc;
    }

</style>
<div class="mi-card">
    <div class="mi-header info"> {{orderPageTitle()}} </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>ORDER NUMBER</th>
                    <th>QTY</th>
                    <th>CUSTOMER INFO</th>
                    <th>PAYMENT METHOD</th>
                    <th>ORDER TOTAL</th>
                    <th>STATUS</th>
                    <th>ACTION</th>
                </tr>
            </thead>
            <tbody>
                @foreach($orders as $order)
                <tr>
                    <td>{{ $order->id }}</td>
                    <td>
                        <p><span>Number:</span> {{ $order->order_number }}</p>
                        <p><span>date:</span> {{ date('Y M d',strtotime($order->created_at)) }}</p>
                    </td>
                    <td class="center">{{ $order->qty }}</td>
                    <td>
                        <p><span>Name: </span>{{ optional($order->user)->first_name }} {{ optional($order->user)->last_name }}</p>
                        <p><span>Phone: </span>{{ optional($order->user)->phone }}</p>
                    </td>
                    <td class="center">
                        {{ getPaymentMethod($order->payment_method) }}
                    </td>
                    <td>
                        <p><span>Total: </span>৳ {{ $order->order_total+$order->tax+$order->delivery_charge }}</p>
                        <p><span>Discount: </span>-৳ {{ $order->discount_amount }}</p>
                    </td>
                    <td class="center">
                        {!! getStatusWithColor($order->status) !!}
                    </td>
                    <td>
                        <a href="{{ route('order.view',['id'=>$order->id]) }}"><button class="butn info transparent butn-sm "><i class="fa fa-eye"></i></button></a>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
