@extends('theme.theme')
@section('content')
<div class="mi-card">
    <div class="mi-header info">
        All Packages
        <a href="{{ route('admin.mystore.package.create') }}">
            <button class="butn success mi-right">Add Package</button>
        </a>
    </div>
    <div class="mi-body">
        <table class="table table-bordered mi-table" id="dataTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Package Name</th>
                    <th>Price</th>
                    <th>TSC</th>
                    <th>Daily Income Limit</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach($packages as $package)
                    <tr>
                        <td>{{ $package->id }}</td>
                        <td>{{ $package->name }}</td>
                        <td>{{ numberformat($package->price) }}</td>
                        <td>{{ $package->tsc }}%</td>
                        <td>{{ numberformat($package->daily_income) }}</td>
                        <td>
                            <a href="{{ route('admin.mystore.package.edit', ['id' => $package->id]) }}">
                                <button class="butn butn-sm warning transparent">
                                    <i class="fa fa-edit"></i>
                                </button>
                            </a>
                            <a
                                onclick="deleteConfirm('{{ route('admin.mystore.package.delete', ['id' => $package->id]) }}','Are you sure to delete')">
                                <button class="butn butn-sm danger transparent">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
