@extends('theme.theme')
@section('content')
<div class="row">
    <div class="col-sm-6 m-auto">
        <div class="mi-card">
            <div class="mi-header info">
                {{ $package ? 'Edit Package' : 'Create Package' }}
            </div>
            <form action="{{ route('admin.mystore.package.store',['id'=>$package?->id]) }}" method="POST">
                @csrf
                <div class="mi-body">
                    <div class="form-group">
                        <label for="">Name <b class="text-danger">*</b></label>
                        <input type="text" name="name" id="name" class="form-control" value="{{ $package?->name }}" required>
                    </div>
                    <div class="form-group">
                        <label for="">Price <b class="text-danger">*</b></label>
                        <div class="input-group">
                            <input type="number" name="price" id="price" class="form-control" value="{{ $package?->price }}" required>
                            <span class="input-group-text" id="basic-addon1">{{ taka() }}</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="">TSC <b class="text-danger">*</b></label>
                        <div class="input-group">
                            <input type="number" name="tsc" id="tsc" class="form-control" value="{{ $package?->tsc }}" required>
                            <span class="input-group-text" id="basic-addon1">%</span>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="">Daily Income Limit <b class="text-danger">*</b></label>
                        <div class="input-group">
                            <input type="number" name="daily_income" id="daily_income" class="form-control" value="{{ $package?->daily_income }}"
                                required>
                            <span class="input-group-text" id="basic-addon1">{{ taka() }}</span>
                        </div>
                    </div>
                </div>
                <div class="mi-footer d-flex justify-content-end">
                    <button type="submit" class="butn success">SAVE</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
